/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jabref.logic.cleanup.CleanupJob;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.util.OptionalUtil;
import org.jabref.preferences.FilePreferences;

public class RemoveLinksToNotExistentFiles
implements CleanupJob {
    private final BibDatabaseContext databaseContext;
    private final FilePreferences filePreferences;

    public RemoveLinksToNotExistentFiles(BibDatabaseContext databaseContext, FilePreferences filePreferences) {
        this.databaseContext = Objects.requireNonNull(databaseContext);
        this.filePreferences = Objects.requireNonNull(filePreferences);
    }

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        List<LinkedFile> files = entry.getFiles();
        ArrayList<LinkedFile> cleanedUpFiles = new ArrayList<LinkedFile>();
        boolean changed = false;
        for (LinkedFile file : files) {
            if (file.isOnlineLink()) {
                cleanedUpFiles.add(file);
                continue;
            }
            Optional<Path> oldFile = file.findIn(this.databaseContext, this.filePreferences);
            if (oldFile.isEmpty()) {
                changed = true;
                continue;
            }
            cleanedUpFiles.add(file);
        }
        if (changed) {
            Optional<FieldChange> changes = entry.setFiles(cleanedUpFiles);
            return OptionalUtil.toList(changes);
        }
        return Collections.emptyList();
    }
}

