/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jabref.logic.bibtex.FileFieldWriter;
import org.jabref.logic.cleanup.CleanupJob;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;

public class UpgradePdfPsToFileCleanup
implements CleanupJob {
    private final Map<Field, String> fields = new HashMap<Field, String>();

    public UpgradePdfPsToFileCleanup() {
        this.fields.put(StandardField.PDF, "PDF");
        this.fields.put(StandardField.PS, "PostScript");
    }

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        String oldFileContent = entry.getField(StandardField.FILE).orElse(null);
        ArrayList<LinkedFile> fileList = new ArrayList<LinkedFile>(entry.getFiles());
        int oldItemCount = fileList.size();
        for (Map.Entry<Field, String> field : this.fields.entrySet()) {
            entry.getField(field.getKey()).ifPresent(fieldContent -> {
                if (fieldContent.trim().isEmpty()) {
                    return;
                }
                Path path = Path.of(fieldContent, new String[0]);
                LinkedFile flEntry = new LinkedFile(path.getFileName().toString(), path, (String)field.getValue());
                fileList.add(flEntry);
                entry.clearField((Field)field.getKey());
                changes.add(new FieldChange(entry, (Field)field.getKey(), (String)fieldContent, null));
            });
        }
        if (fileList.size() != oldItemCount) {
            String newValue = FileFieldWriter.getStringRepresentation(fileList);
            entry.setField(StandardField.FILE, newValue);
            changes.add(new FieldChange(entry, StandardField.FILE, oldFileContent, newValue));
        }
        return changes;
    }
}

