/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.crawler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.PagedSearchBasedFetcher;
import org.jabref.logic.importer.SearchBasedFetcher;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.study.FetchResult;
import org.jabref.model.study.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StudyFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(StudyFetcher.class);
    private static final int MAX_AMOUNT_OF_RESULTS_PER_FETCHER = 100;
    private final List<SearchBasedFetcher> activeFetchers;
    private final List<String> searchQueries;

    StudyFetcher(List<SearchBasedFetcher> activeFetchers, List<String> searchQueries) throws IllegalArgumentException {
        this.searchQueries = searchQueries;
        this.activeFetchers = activeFetchers;
    }

    public List<QueryResult> crawl() {
        return this.searchQueries.parallelStream().map(this::getQueryResult).collect(Collectors.toList());
    }

    private QueryResult getQueryResult(String searchQuery) {
        return new QueryResult(searchQuery, this.performSearchOnQuery(searchQuery));
    }

    private List<FetchResult> performSearchOnQuery(String searchQuery) {
        return this.activeFetchers.parallelStream().map(fetcher -> this.performSearchOnQueryForFetcher(searchQuery, (SearchBasedFetcher)fetcher)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private FetchResult performSearchOnQueryForFetcher(String searchQuery, SearchBasedFetcher fetcher) {
        try {
            ArrayList<BibEntry> fetchResult = new ArrayList();
            if (fetcher instanceof PagedSearchBasedFetcher) {
                PagedSearchBasedFetcher basedFetcher = (PagedSearchBasedFetcher)fetcher;
                int pages = (int)Math.ceil(100.0 / (double)basedFetcher.getPageSize());
                for (int page = 0; page < pages; ++page) {
                    fetchResult.addAll(basedFetcher.performSearchPaged(searchQuery, page).getContent());
                }
            } else {
                fetchResult = fetcher.performSearch(searchQuery);
            }
            return new FetchResult(fetcher.getName(), new BibDatabase(fetchResult));
        }
        catch (FetcherException e) {
            LOGGER.warn("%s API request failed".formatted(fetcher.getName()), (Throwable)e);
            return null;
        }
    }
}

