/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.database;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jabref.logic.database.DuplicateCheck;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseModeDetection;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.BibtexString;
import org.jabref.model.groups.AllEntriesGroup;
import org.jabref.model.groups.ExplicitGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.metadata.ContentSelector;
import org.jabref.model.metadata.MetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMerger {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseMerger.class);
    private final char keywordDelimiter;

    public DatabaseMerger(char keywordDelimiter) {
        this.keywordDelimiter = keywordDelimiter;
    }

    public synchronized void merge(BibDatabase target, BibDatabase other) {
        this.mergeEntries(target, other);
        this.mergeStrings(target, other);
    }

    public synchronized void merge(BibDatabaseContext target, BibDatabaseContext other, String otherFileName) {
        this.mergeEntries(target.getDatabase(), other.getDatabase());
        this.mergeStrings(target.getDatabase(), other.getDatabase());
        this.mergeMetaData(target.getMetaData(), other.getMetaData(), otherFileName, other.getEntries());
    }

    private void mergeEntries(BibDatabase target, BibDatabase other) {
        DuplicateCheck duplicateCheck = new DuplicateCheck(new BibEntryTypesManager());
        List<BibEntry> newEntries = other.getEntries().stream().filter(entry -> duplicateCheck.containsDuplicate(target, (BibEntry)entry, BibDatabaseModeDetection.inferMode(target)).isEmpty()).collect(Collectors.toList());
        target.insertEntries(newEntries);
    }

    public void mergeStrings(BibDatabase target, BibDatabase other) {
        for (BibtexString bibtexString : other.getStringValues()) {
            String bibtexStringName = bibtexString.getName();
            if (target.hasStringByName(bibtexStringName)) {
                String existingContent;
                String importedContent = bibtexString.getContent();
                if (importedContent.equals(existingContent = target.getStringByName(bibtexStringName).get().getContent())) continue;
                LOGGER.info("String contents differ for {}: {} != {}", new Object[]{bibtexStringName, importedContent, existingContent});
                int suffix = 1;
                String newName = bibtexStringName + "_" + suffix;
                while (target.hasStringByName(newName)) {
                    newName = bibtexStringName + "_" + ++suffix;
                }
                BibtexString newBibtexString = new BibtexString(newName, importedContent);
                target.addString(newBibtexString);
                LOGGER.info("New string added: {} = {}", (Object)newBibtexString.getName(), (Object)newBibtexString.getContent());
                continue;
            }
            target.addString(bibtexString);
        }
    }

    public void mergeMetaData(MetaData target, MetaData other, String otherFilename, List<BibEntry> allOtherEntries) {
        Objects.requireNonNull(other);
        Objects.requireNonNull(otherFilename);
        Objects.requireNonNull(allOtherEntries);
        this.mergeGroups(target, other, otherFilename, allOtherEntries);
        this.mergeContentSelectors(target, other);
    }

    private void mergeGroups(MetaData target, MetaData other, String otherFilename, List<BibEntry> allOtherEntries) {
        other.getGroups().ifPresent(newGroups -> {
            if (newGroups.getGroup() instanceof AllEntriesGroup) {
                try {
                    String newGroupName = otherFilename;
                    ExplicitGroup group = new ExplicitGroup("Imported " + newGroupName, GroupHierarchyType.INDEPENDENT, Character.valueOf(this.keywordDelimiter));
                    newGroups.setGroup(group);
                    group.add(allOtherEntries);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Problem appending entries to group", (Throwable)e);
                }
            }
            target.getGroups().ifPresentOrElse(newGroups::moveTo, () -> target.setGroups((GroupTreeNode)newGroups));
        });
    }

    private void mergeContentSelectors(MetaData target, MetaData other) {
        for (ContentSelector selector : other.getContentSelectorsSorted()) {
            target.addContentSelector(selector);
        }
    }
}

