/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.bibtexfields;

import java.util.Objects;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.l10n.Localization;

public class AddBracesFormatter
extends Formatter {
    @Override
    public String getName() {
        return Localization.lang("Add enclosing braces", new Object[0]);
    }

    @Override
    public String getKey() {
        return "add_braces";
    }

    @Override
    public String format(String value) {
        Objects.requireNonNull(value);
        if (value.length() >= 2 && value.charAt(0) != '{' && value.charAt(value.length() - 1) != '}') {
            return "{" + value + "}";
        }
        return value;
    }

    @Override
    public String getDescription() {
        return Localization.lang("Add braces encapsulating the complete field content.", new Object[0]);
    }

    @Override
    public String getExampleInput() {
        return "In CDMA";
    }
}

