/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.bibtexfields;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.formatter.casechanger.UnprotectTermsFormatter;
import org.jabref.logic.l10n.Localization;

public class NormalizePagesFormatter
extends Formatter {
    private static final Pattern EM_EN_DASH_PATTERN = Pattern.compile("\u2013|\u2014");
    private static final Pattern DASHES_DETECT_PATTERN = Pattern.compile("[ ]*-+[ ]*");
    private final Formatter unprotectTermsFormatter = new UnprotectTermsFormatter();

    @Override
    public String getName() {
        return Localization.lang("Normalize page numbers", new Object[0]);
    }

    @Override
    public String getKey() {
        return "normalize_page_numbers";
    }

    @Override
    public String format(String value) {
        Objects.requireNonNull(value);
        if (value.isEmpty()) {
            return value;
        }
        value = value.trim();
        value = value.replace("pp.", "").replace("p.", "").trim();
        Matcher matcher = DASHES_DETECT_PATTERN.matcher(value = EM_EN_DASH_PATTERN.matcher(value).replaceAll("--"));
        if (matcher.find() && matcher.start() >= 0) {
            String fixedValue = matcher.replaceFirst("--");
            if (matcher.find()) {
                return value;
            }
            return this.unprotectTermsFormatter.format(fixedValue);
        }
        return value;
    }

    @Override
    public String getDescription() {
        return Localization.lang("Normalize pages to BibTeX standard.", new Object[0]);
    }

    @Override
    public String getExampleInput() {
        return "1 - 2";
    }
}

