/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.minifier;

import java.util.Objects;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.l10n.Localization;

public class TruncateFormatter
extends Formatter {
    private final int TRUNCATE_AFTER;
    private final String KEY;

    public TruncateFormatter(int truncateIndex) {
        this.TRUNCATE_AFTER = truncateIndex >= 0 ? truncateIndex : Integer.MAX_VALUE;
        this.KEY = "truncate" + this.TRUNCATE_AFTER;
    }

    @Override
    public String getName() {
        return Localization.lang("Truncate", new Object[0]);
    }

    @Override
    public String getKey() {
        return this.KEY;
    }

    @Override
    public String format(String input) {
        Objects.requireNonNull(input);
        int index = Math.min(this.TRUNCATE_AFTER, input.length());
        return input.substring(0, index).stripTrailing();
    }

    @Override
    public String getDescription() {
        return Localization.lang("Truncates a string after a given index.", new Object[0]);
    }

    @Override
    public String getExampleInput() {
        return "Truncate this sentence.";
    }
}

