/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.git;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.jabref.logic.util.io.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHandler {
    static final Logger LOGGER = LoggerFactory.getLogger(GitHandler.class);
    final Path repositoryPath;
    final File repositoryPathAsFile;
    String gitUsername;
    String gitPassword;
    final CredentialsProvider credentialsProvider;

    public GitHandler(Path repositoryPath) {
        block9: {
            this.gitUsername = Optional.ofNullable(System.getenv("GIT_EMAIL")).orElse("");
            this.gitPassword = Optional.ofNullable(System.getenv("GIT_PW")).orElse("");
            this.credentialsProvider = new UsernamePasswordCredentialsProvider(this.gitUsername, this.gitPassword);
            this.repositoryPath = repositoryPath;
            this.repositoryPathAsFile = this.repositoryPath.toFile();
            if (!this.isGitRepository()) {
                try {
                    Git.init().setDirectory(this.repositoryPathAsFile).setInitialBranch("main").call();
                    this.setupGitIgnore();
                    String initialCommit = "Initial commit";
                    if (this.createCommitOnCurrentBranch(initialCommit, false)) break block9;
                    try (Git git = Git.open((File)this.repositoryPathAsFile);){
                        git.commit().setAllowEmpty(true).setMessage(initialCommit).call();
                    }
                }
                catch (IOException | GitAPIException e) {
                    LOGGER.error("Initialization failed");
                }
            }
        }
    }

    void setupGitIgnore() {
        try {
            Path gitignore = Path.of(this.repositoryPath.toString(), ".gitignore");
            if (!Files.exists(gitignore, new LinkOption[0])) {
                FileUtil.copyFile(Path.of(this.getClass().getResource("git.gitignore").toURI()), gitignore, false);
            }
        }
        catch (URISyntaxException e) {
            LOGGER.error("Error occurred during copying of the gitignore file into the git repository.", (Throwable)e);
        }
    }

    boolean isGitRepository() {
        return Files.exists(Path.of(this.repositoryPath.toString(), ".git"), new LinkOption[0]);
    }

    public void checkoutBranch(String branchToCheckout) throws IOException, GitAPIException {
        try (Git git = Git.open((File)this.repositoryPathAsFile);){
            Optional<Ref> branch = this.getRefForBranch(branchToCheckout);
            git.checkout().setCreateBranch(branch.isEmpty()).setName(branchToCheckout).call();
        }
    }

    Optional<Ref> getRefForBranch(String branchName) throws GitAPIException, IOException {
        try (Git git = Git.open((File)this.repositoryPathAsFile);){
            Optional<Ref> optional = git.branchList().call().stream().filter(ref -> ref.getName().equals("refs/heads/" + branchName)).findAny();
            return optional;
        }
    }

    public boolean createCommitOnCurrentBranch(String commitMessage, boolean amend) throws IOException, GitAPIException {
        boolean commitCreated = false;
        try (Git git = Git.open((File)this.repositoryPathAsFile);){
            Status status = git.status().call();
            if (!status.isClean()) {
                commitCreated = true;
                git.add().addFilepattern(".").call();
                if (!status.getMissing().isEmpty()) {
                    RmCommand removeCommand = git.rm().setCached(true);
                    status.getMissing().forEach(arg_0 -> ((RmCommand)removeCommand).addFilepattern(arg_0));
                    removeCommand.call();
                }
                git.commit().setAmend(amend).setAllowEmpty(false).setMessage(commitMessage).call();
            }
        }
        return commitCreated;
    }

    public void mergeBranches(String targetBranch, String sourceBranch, MergeStrategy mergeStrategy) throws IOException, GitAPIException {
        String currentBranch = this.getCurrentlyCheckedOutBranch();
        try (Git git = Git.open((File)this.repositoryPathAsFile);){
            Optional<Ref> sourceBranchRef = this.getRefForBranch(sourceBranch);
            if (sourceBranchRef.isEmpty()) {
                return;
            }
            this.checkoutBranch(targetBranch);
            git.merge().include(sourceBranchRef.get()).setStrategy(mergeStrategy).setMessage("Merge search branch into working branch.").call();
        }
        this.checkoutBranch(currentBranch);
    }

    public void pushCommitsToRemoteRepository() throws IOException {
        try (Git git = Git.open((File)this.repositoryPathAsFile);){
            try {
                ((PushCommand)git.push().setCredentialsProvider(this.credentialsProvider)).call();
            }
            catch (GitAPIException e) {
                LOGGER.info("Failed to push");
            }
        }
    }

    public void pullOnCurrentBranch() throws IOException {
        try (Git git = Git.open((File)this.repositoryPathAsFile);){
            try {
                ((PullCommand)git.pull().setCredentialsProvider(this.credentialsProvider)).call();
            }
            catch (GitAPIException e) {
                LOGGER.info("Failed to push");
            }
        }
    }

    public String getCurrentlyCheckedOutBranch() throws IOException {
        try (Git git = Git.open((File)this.repositoryPathAsFile);){
            String string = git.getRepository().getBranch();
            return string;
        }
    }
}

