/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.git;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.jabref.logic.git.GitHandler;

public class SlrGitHandler
extends GitHandler {
    public SlrGitHandler(Path repositoryPath) {
        super(repositoryPath);
    }

    public void appendLatestSearchResultsOntoCurrentBranch(String patchMessage, String searchBranchName) throws IOException, GitAPIException {
        String patch = this.calculatePatchOfNewSearchResults(searchBranchName);
        Map<Path, String> result = this.parsePatchForAddedEntries(patch);
        this.applyPatch(result);
        this.createCommitOnCurrentBranch(patchMessage, false);
    }

    /*
     * Exception decompiling
     */
    String calculatePatchOfNewSearchResults(String sourceBranch) throws IOException, GitAPIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Map<Path, String> parsePatchForAddedEntries(String patch) throws IOException, GitAPIException {
        String[] tokens = patch.split("\n");
        HashMap<Path, String> diffsPerFile = new HashMap<Path, String>();
        boolean content = false;
        StringJoiner joiner = null;
        String relativePath = null;
        for (String currentToken : tokens) {
            if (currentToken.startsWith("diff --git a/")) {
                if (relativePath != null && joiner != null && !relativePath.contains("study.yml")) {
                    diffsPerFile.put(Path.of(this.repositoryPath.toString(), relativePath), joiner.toString());
                }
                relativePath = currentToken.substring(13, currentToken.indexOf(" b/"));
                content = false;
                joiner = new StringJoiner("\n");
                continue;
            }
            if (currentToken.startsWith("@@ ") && currentToken.endsWith(" @@")) {
                content = true;
                continue;
            }
            if (!content || !currentToken.startsWith("+") || joiner == null) continue;
            joiner.add(currentToken.substring(1));
        }
        if (relativePath != null && joiner != null) {
            diffsPerFile.put(Path.of(this.repositoryPath.toString(), relativePath), joiner.toString());
        }
        return diffsPerFile;
    }

    void applyPatch(Map<Path, String> patch) {
        patch.keySet().forEach(path -> {
            try {
                String currentContent = Files.readString(path);
                Object prefix = "";
                if (currentContent.startsWith("% Encoding:")) {
                    int endOfEncoding = currentContent.indexOf("\n");
                    prefix = currentContent.substring(0, endOfEncoding + 1) + "\n";
                    currentContent = currentContent.substring(endOfEncoding + 2);
                }
                Files.writeString(path, (CharSequence)((String)prefix + (String)patch.get(path) + currentContent), StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                LOGGER.error("Could not apply patch.");
            }
        });
    }
}

