/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabases;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.metadata.MetaData;

public class ParserResult {
    private final Set<BibEntryType> entryTypes;
    private final List<String> warnings = new ArrayList<String>();
    private BibDatabase database;
    private MetaData metaData;
    private Path file;
    private boolean invalid;
    private boolean toOpenTab;
    private boolean changedOnMigration = false;

    public ParserResult() {
        this(Collections.emptyList());
    }

    public ParserResult(Collection<BibEntry> entries) {
        this(new BibDatabase(BibDatabases.purgeEmptyEntries(entries)));
    }

    public ParserResult(BibDatabase database) {
        this(database, new MetaData(), new HashSet<BibEntryType>());
    }

    public ParserResult(BibDatabase database, MetaData metaData, Set<BibEntryType> entryTypes) {
        this.database = Objects.requireNonNull(database);
        this.metaData = Objects.requireNonNull(metaData);
        this.entryTypes = Objects.requireNonNull(entryTypes);
    }

    public static ParserResult fromErrorMessage(String message) {
        ParserResult parserResult = new ParserResult();
        parserResult.addWarning(message);
        parserResult.setInvalid(true);
        return parserResult;
    }

    private static String getErrorMessage(Exception exception) {
        Object errorMessage = exception.getLocalizedMessage();
        if (exception.getCause() != null) {
            errorMessage = (String)errorMessage + " Caused by: " + exception.getCause().getLocalizedMessage();
        }
        return errorMessage;
    }

    public static ParserResult fromError(Exception exception) {
        return ParserResult.fromErrorMessage(ParserResult.getErrorMessage(exception));
    }

    public boolean toOpenTab() {
        return this.toOpenTab;
    }

    public void setToOpenTab() {
        this.toOpenTab = true;
    }

    public BibDatabase getDatabase() {
        return this.database;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData md) {
        this.metaData = md;
    }

    public Set<BibEntryType> getEntryTypes() {
        return this.entryTypes;
    }

    public Optional<Path> getPath() {
        return Optional.ofNullable(this.file);
    }

    public void setPath(Path path) {
        this.file = path;
    }

    public void addWarning(String s) {
        if (!this.warnings.contains(s)) {
            this.warnings.add(s);
        }
    }

    public void addException(Exception exception) {
        String errorMessage = ParserResult.getErrorMessage(exception);
        this.addWarning(errorMessage);
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public List<String> warnings() {
        return new ArrayList<String>(this.warnings);
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    public String getErrorMessage() {
        return String.join((CharSequence)"\n", this.warnings());
    }

    public BibDatabaseContext getDatabaseContext() {
        return new BibDatabaseContext(this.database, this.metaData, this.file);
    }

    public void setDatabaseContext(BibDatabaseContext bibDatabaseContext) {
        Objects.requireNonNull(bibDatabaseContext);
        this.database = bibDatabaseContext.getDatabase();
        this.metaData = bibDatabaseContext.getMetaData();
        this.file = bibDatabaseContext.getDatabasePath().orElse(null);
    }

    public boolean isEmpty() {
        return !this.getDatabase().hasEntries() && this.getDatabase().hasNoStrings() && this.getDatabase().getPreamble().isEmpty() && this.getMetaData().isEmpty();
    }

    public boolean wasChangedOnMigration() {
        return this.changedOnMigration;
    }

    public void setChangedOnMigration(boolean wasChangedOnMigration) {
        this.changedOnMigration = wasChangedOnMigration;
    }
}

