/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Objects;
import java.util.Optional;
import kong.unirest.core.Unirest;
import org.jabref.logic.importer.FulltextFetcher;
import org.jabref.logic.importer.fetcher.TrustLevel;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.DOI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApsFetcher
implements FulltextFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApsFetcher.class);
    private static final String DOI_URL = "https://www.doi.org/";
    private static final String PDF_URL = "https://journals.aps.org/prl/pdf/";

    @Override
    public Optional<URL> findFullText(BibEntry entry) throws IOException {
        String pdfRequestUrl;
        int code;
        Objects.requireNonNull(entry);
        Optional doi = entry.getField(StandardField.DOI).flatMap(DOI::parse);
        if (!doi.isPresent()) {
            return Optional.empty();
        }
        Optional<String> id = this.getId(((DOI)doi.get()).getDOI());
        if (id.isPresent() && (code = Unirest.head((String)(pdfRequestUrl = PDF_URL + id.get())).asJson().getStatus()) == 200) {
            LOGGER.info("Fulltext PDF found @ APS.");
            try {
                return Optional.of(new URL(pdfRequestUrl));
            }
            catch (MalformedURLException e) {
                LOGGER.warn("APS returned malformed URL, cannot find PDF.");
            }
        }
        return Optional.empty();
    }

    @Override
    public TrustLevel getTrustLevel() {
        return TrustLevel.PUBLISHER;
    }

    private Optional<String> getId(String doi) {
        String doiRequest = DOI_URL + doi;
        try {
            URLConnection con = new URL(doiRequest).openConnection();
            con.connect();
            con.getInputStream();
            String[] urlParts = con.getURL().toString().split("abstract/");
            if (urlParts.length == 2) {
                return Optional.of(urlParts[1]);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error connecting to APS", (Throwable)e);
        }
        return Optional.empty();
    }
}

