/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kong.unirest.core.json.JSONArray;
import kong.unirest.core.json.JSONObject;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.FulltextFetcher;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.ImporterPreferences;
import org.jabref.logic.importer.PagedSearchBasedParserFetcher;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.fetcher.CustomizableKeyFetcher;
import org.jabref.logic.importer.fetcher.TrustLevel;
import org.jabref.logic.importer.fetcher.transformers.IEEEQueryTransformer;
import org.jabref.logic.net.URLDownload;
import org.jabref.logic.util.BuildInfo;
import org.jabref.logic.util.OS;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.model.entry.types.StandardEntryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IEEE
implements FulltextFetcher,
PagedSearchBasedParserFetcher,
CustomizableKeyFetcher {
    public static final String FETCHER_NAME = "IEEEXplore";
    private static final Logger LOGGER = LoggerFactory.getLogger(IEEE.class);
    private static final String STAMP_BASE_STRING_DOCUMENT = "/stamp/stamp.jsp?tp=&arnumber=";
    private static final Pattern STAMP_PATTERN = Pattern.compile("(/stamp/stamp.jsp\\?t?p?=?&?arnumber=[0-9]+)");
    private static final Pattern DOCUMENT_PATTERN = Pattern.compile("document/([0-9]+)/");
    private static final Pattern PDF_PATTERN = Pattern.compile("\"(https://ieeexplore.ieee.org/ielx[0-9/]+\\.pdf[^\"]+)\"");
    private static final String IEEE_DOI = "10.1109";
    private static final String BASE_URL = "https://ieeexplore.ieee.org";
    private static final String API_KEY = new BuildInfo().ieeeAPIKey;
    private static final String TEST_URL_WITHOUT_API_KEY = "https://ieeexploreapi.ieee.org/api/v1/search/articles?max_records=0&apikey=";
    private final ImportFormatPreferences importFormatPreferences;
    private final ImporterPreferences importerPreferences;
    private IEEEQueryTransformer transformer;

    public IEEE(ImportFormatPreferences importFormatPreferences, ImporterPreferences importerPreferences) {
        this.importFormatPreferences = Objects.requireNonNull(importFormatPreferences);
        this.importerPreferences = Objects.requireNonNull(importerPreferences);
    }

    private static BibEntry parseJsonResponse(JSONObject jsonEntry, Character keywordSeparator) {
        BibEntry entry = new BibEntry();
        switch (jsonEntry.optString("content_type")) {
            case "Books": {
                entry.setType(StandardEntryType.Book);
                break;
            }
            case "Conferences": {
                entry.setType(StandardEntryType.InProceedings);
                break;
            }
            case "Courses": {
                entry.setType(StandardEntryType.Misc);
                break;
            }
            default: {
                entry.setType(StandardEntryType.Article);
            }
        }
        entry.setField(StandardField.ABSTRACT, jsonEntry.optString("abstract"));
        ArrayList authors = new ArrayList();
        JSONObject authorsContainer = jsonEntry.optJSONObject("authors");
        authorsContainer.getJSONArray("authors").forEach(authorPure -> {
            JSONObject author = (JSONObject)authorPure;
            authors.add(author.optString("full_name"));
        });
        entry.setField(StandardField.AUTHOR, String.join((CharSequence)" and ", authors));
        entry.setField(StandardField.LOCATION, jsonEntry.optString("conference_location"));
        entry.setField(StandardField.DOI, jsonEntry.optString("doi"));
        entry.setField(StandardField.YEAR, jsonEntry.optString("publication_year"));
        entry.setField(StandardField.PAGES, jsonEntry.optString("start_page") + "--" + jsonEntry.optString("end_page"));
        JSONObject keywordsContainer = jsonEntry.optJSONObject("index_terms");
        if (keywordsContainer != null) {
            if (keywordsContainer.has("ieee_terms")) {
                keywordsContainer.getJSONObject("ieee_terms").getJSONArray("terms").forEach(data -> {
                    String keyword = (String)data;
                    entry.addKeyword(keyword, keywordSeparator);
                });
            }
            if (keywordsContainer.has("author_terms")) {
                keywordsContainer.getJSONObject("author_terms").getJSONArray("terms").forEach(data -> {
                    String keyword = (String)data;
                    entry.addKeyword(keyword, keywordSeparator);
                });
            }
        }
        entry.setField(StandardField.ISBN, jsonEntry.optString("isbn"));
        entry.setField(StandardField.ISSN, jsonEntry.optString("issn"));
        entry.setField(StandardField.ISSUE, jsonEntry.optString("issue"));
        try {
            entry.addFile(new LinkedFile(new URL(jsonEntry.optString("pdf_url")), "PDF"));
        }
        catch (MalformedURLException e) {
            LOGGER.error("Fetched PDF URL String is malformed.");
        }
        entry.setField(StandardField.JOURNALTITLE, jsonEntry.optString("publication_title"));
        entry.setField(StandardField.DATE, jsonEntry.optString("publication_date"));
        entry.setField(StandardField.EVENTTITLEADDON, jsonEntry.optString("conference_location"));
        entry.setField(StandardField.EVENTDATE, jsonEntry.optString("conference_dates"));
        entry.setField(StandardField.PUBLISHER, jsonEntry.optString("publisher"));
        entry.setField(StandardField.TITLE, jsonEntry.optString("title"));
        entry.setField(StandardField.VOLUME, jsonEntry.optString("volume"));
        return entry;
    }

    @Override
    public Optional<URL> findFullText(BibEntry entry) throws IOException {
        Optional doi;
        Objects.requireNonNull(entry);
        Object stampString = "";
        Optional<String> urlString = entry.getField(StandardField.URL);
        if (urlString.isPresent()) {
            Matcher stampMatcher;
            Matcher documentUrlMatcher = DOCUMENT_PATTERN.matcher(urlString.get());
            if (documentUrlMatcher.find()) {
                String docId = documentUrlMatcher.group(1);
                stampString = STAMP_BASE_STRING_DOCUMENT + docId;
            }
            if ((stampMatcher = STAMP_PATTERN.matcher(urlString.get())).find()) {
                stampString = stampMatcher.group(1);
            }
        }
        if (((String)stampString).isEmpty() && (doi = entry.getField(StandardField.DOI).flatMap(DOI::parse)).isPresent() && ((DOI)doi.get()).getDOI().startsWith(IEEE_DOI) && ((DOI)doi.get()).getExternalURI().isPresent()) {
            URLDownload urlDownload = new URLDownload(((DOI)doi.get()).getExternalURI().get().toURL());
            urlDownload.getCookieFromUrl();
            String resolvedDOIPage = urlDownload.asString();
            Matcher matcher = STAMP_PATTERN.matcher(resolvedDOIPage);
            if (matcher.find()) {
                stampString = matcher.group(1);
            }
        }
        if (((String)stampString).isEmpty()) {
            return Optional.empty();
        }
        URLDownload urlDownload = new URLDownload(BASE_URL + (String)stampString);
        urlDownload.getCookieFromUrl();
        String framePage = urlDownload.asString();
        Matcher matcher = PDF_PATTERN.matcher(framePage);
        if (matcher.find()) {
            LOGGER.debug("Full text document found on IEEE Xplore");
            return Optional.of(new URL(matcher.group(1)));
        }
        return Optional.empty();
    }

    @Override
    public TrustLevel getTrustLevel() {
        return TrustLevel.PUBLISHER;
    }

    @Override
    public Parser getParser() {
        return inputStream -> {
            String response = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining(OS.NEWLINE));
            JSONObject jsonObject = new JSONObject(response);
            ArrayList<BibEntry> entries = new ArrayList<BibEntry>();
            if (jsonObject.has("articles")) {
                JSONArray results = jsonObject.getJSONArray("articles");
                for (int i = 0; i < results.length(); ++i) {
                    JSONObject jsonEntry = results.getJSONObject(i);
                    BibEntry entry = IEEE.parseJsonResponse(jsonEntry, this.importFormatPreferences.bibEntryPreferences().getKeywordSeparator());
                    boolean addEntry = entry.hasField(StandardField.YEAR) ? entry.getField(StandardField.YEAR).filter(year -> {
                        int yearAsInteger = Integer.parseInt(year);
                        return this.transformer.getStartYear().map(startYear -> yearAsInteger >= startYear).orElse(true) != false && this.transformer.getEndYear().map(endYear -> yearAsInteger <= endYear).orElse(true) != false;
                    }).isPresent() : true;
                    if (!addEntry) continue;
                    entries.add(entry);
                }
            }
            return entries;
        };
    }

    @Override
    public String getName() {
        return FETCHER_NAME;
    }

    @Override
    public Optional<HelpFile> getHelpPage() {
        return Optional.of(HelpFile.FETCHER_IEEEXPLORE);
    }

    private String getApiKey() {
        return this.importerPreferences.getApiKey(this.getName()).orElse(API_KEY);
    }

    @Override
    public String getTestUrl() {
        return TEST_URL_WITHOUT_API_KEY;
    }

    @Override
    public URL getURLForQuery(QueryNode luceneQuery, int pageNumber) throws URISyntaxException, MalformedURLException, FetcherException {
        this.transformer = new IEEEQueryTransformer();
        String transformedQuery = this.transformer.transformLuceneQuery(luceneQuery).orElse("");
        URIBuilder uriBuilder = new URIBuilder("https://ieeexploreapi.ieee.org/api/v1/search/articles");
        uriBuilder.addParameter("apikey", this.getApiKey());
        if (!transformedQuery.isBlank()) {
            uriBuilder.addParameter("querytext", transformedQuery);
        }
        uriBuilder.addParameter("max_records", String.valueOf(this.getPageSize()));
        if (this.transformer.getJournal().isPresent()) {
            uriBuilder.addParameter("publication_title", this.transformer.getJournal().get());
        }
        if (this.transformer.getStartYear().isPresent()) {
            uriBuilder.addParameter("start_year", String.valueOf(this.transformer.getStartYear().get()));
        }
        if (this.transformer.getEndYear().isPresent()) {
            uriBuilder.addParameter("end_year", String.valueOf(this.transformer.getEndYear().get()));
        }
        if (this.transformer.getArticleNumber().isPresent()) {
            uriBuilder.addParameter("article_number", this.transformer.getArticleNumber().get());
        }
        uriBuilder.addParameter("start_record", String.valueOf(this.getPageSize() * pageNumber) + "1");
        return uriBuilder.build().toURL();
    }
}

