/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.PagedSearchBasedParserFetcher;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.fetcher.transformers.ISIDOREQueryTransformer;
import org.jabref.logic.net.URLDownload;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.StandardEntryType;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ISIDOREFetcher
implements PagedSearchBasedParserFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ISIDOREFetcher.class);
    private static final String SOURCE_WEB_SEARCH = "https://api.isidore.science/resource/search";
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();

    @Override
    public Parser getParser() {
        return xmlData -> {
            try {
                PushbackInputStream pushbackInputStream = new PushbackInputStream(xmlData);
                int data = pushbackInputStream.read();
                if (data == -1) {
                    return List.of();
                }
                if (pushbackInputStream.available() < 5) {
                    pushbackInputStream.unread(data);
                    String error = new String(pushbackInputStream.readAllBytes(), StandardCharsets.UTF_8);
                    throw new FetcherException(error);
                }
                pushbackInputStream.unread(data);
                DocumentBuilder builder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
                Document document = builder.parse(pushbackInputStream);
                Element entryElement = document.getDocumentElement();
                if (entryElement == null) {
                    return Collections.emptyList();
                }
                return this.parseXMl(entryElement);
            }
            catch (FetcherException e) {
                Unchecked.throwChecked((Throwable)e);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                Unchecked.throwChecked((Throwable)new FetcherException("Issue with parsing link", e));
            }
            return null;
        };
    }

    @Override
    public URLDownload getUrlDownload(URL url) {
        URLDownload download = new URLDownload(url);
        download.addHeader("Accept", "application/xml");
        return download;
    }

    @Override
    public URL getURLForQuery(QueryNode luceneQuery, int pageNumber) throws URISyntaxException, MalformedURLException, FetcherException {
        ISIDOREQueryTransformer queryTransformer = new ISIDOREQueryTransformer();
        String transformedQuery = queryTransformer.transformLuceneQuery(luceneQuery).orElse("");
        URIBuilder uriBuilder = new URIBuilder(SOURCE_WEB_SEARCH);
        uriBuilder.addParameter("q", transformedQuery);
        if (pageNumber > 1) {
            uriBuilder.addParameter("page", String.valueOf(pageNumber));
        }
        uriBuilder.addParameter("replies", String.valueOf(this.getPageSize()));
        uriBuilder.addParameter("lang", "en");
        uriBuilder.addParameter("output", "xml");
        queryTransformer.getParameterMap().forEach((k, v) -> uriBuilder.addParameter(k, v));
        URL url = uriBuilder.build().toURL();
        LOGGER.debug("URl for query {}", (Object)url);
        return url;
    }

    private List<BibEntry> parseXMl(Element element) {
        NodeList list = element.getElementsByTagName("isidore");
        ArrayList<BibEntry> bibEntryList = new ArrayList<BibEntry>();
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem = (Element)list.item(i);
            BibEntry bibEntry = this.xmlItemToBibEntry(elem);
            bibEntryList.add(bibEntry);
        }
        return bibEntryList;
    }

    private BibEntry xmlItemToBibEntry(Element itemElement) {
        return new BibEntry(this.getType(itemElement.getElementsByTagName("types").item(0).getChildNodes())).withField(StandardField.TITLE, itemElement.getElementsByTagName("title").item(0).getTextContent().replace("\"", "")).withField(StandardField.AUTHOR, this.getAuthor(itemElement.getElementsByTagName("enrichedCreators").item(0))).withField(StandardField.YEAR, itemElement.getElementsByTagName("date").item(0).getChildNodes().item(1).getTextContent().substring(0, 4)).withField(StandardField.JOURNAL, this.getJournal(itemElement.getElementsByTagName("dc:source"))).withField(StandardField.PUBLISHER, this.getPublishers(itemElement.getElementsByTagName("publishers").item(0))).withField(StandardField.DOI, this.getDOI(itemElement.getElementsByTagName("ore").item(0).getChildNodes()));
    }

    private String getDOI(NodeList list) {
        for (int i = 0; i < list.getLength(); ++i) {
            String content = list.item(i).getTextContent();
            if (content.contains("DOI:")) {
                return content.replace("DOI: ", "");
            }
            if (!list.item(i).getTextContent().contains("doi:")) continue;
            return content.replace("info:doi:", "");
        }
        return "";
    }

    private EntryType getType(NodeList list) {
        for (int i = 0; i < list.getLength(); ++i) {
            String type = list.item(i).getTextContent();
            if (type.contains("article") || type.contains("Article")) {
                return StandardEntryType.Article;
            }
            if (type.contains("thesis") || type.contains("Thesis")) {
                return StandardEntryType.Thesis;
            }
            if (!type.contains("book") && !type.contains("Book")) continue;
            return StandardEntryType.Book;
        }
        return StandardEntryType.Misc;
    }

    private String getAuthor(Node itemElement) {
        StringJoiner stringJoiner = new StringJoiner(" and ");
        for (int i = 1; i < itemElement.getChildNodes().getLength(); i += 2) {
            String next = this.removeNumbers(itemElement.getChildNodes().item(i).getTextContent()).replaceAll("\\s+", " ");
            if ((next = next.replace("\n", "")).isBlank()) continue;
            stringJoiner.add(next);
        }
        return stringJoiner.toString().substring(0, stringJoiner.length()).trim().replaceAll("\\s+", " ");
    }

    private String removeNumbers(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isDigit(string.charAt(i))) continue;
            return string.substring(0, i);
        }
        return string;
    }

    private String getPublishers(Node itemElement) {
        if (itemElement == null) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (int i = 0; i < itemElement.getChildNodes().getLength(); ++i) {
            if (itemElement.getChildNodes().item(i).getTextContent().isBlank()) continue;
            stringJoiner.add(itemElement.getChildNodes().item(i).getTextContent().trim());
        }
        return stringJoiner.toString();
    }

    private String getJournal(NodeList list) {
        if (list.getLength() == 0) {
            return "";
        }
        String reference = list.item(list.getLength() - 1).getTextContent();
        for (int i = 0; i < reference.length(); ++i) {
            if (reference.charAt(i) != ',') continue;
            return reference.substring(0, i);
        }
        return "";
    }

    @Override
    public String getName() {
        return "ISIDORE";
    }

    @Override
    public Optional<HelpFile> getHelpPage() {
        return Optional.of(HelpFile.FETCHER_ISIDORE);
    }
}

