/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kong.unirest.core.json.JSONArray;
import kong.unirest.core.json.JSONException;
import kong.unirest.core.json.JSONObject;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.jabref.logic.importer.EntryBasedFetcher;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.FulltextFetcher;
import org.jabref.logic.importer.ImporterPreferences;
import org.jabref.logic.importer.PagedSearchBasedParserFetcher;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.fetcher.CustomizableKeyFetcher;
import org.jabref.logic.importer.fetcher.TrustLevel;
import org.jabref.logic.importer.fetcher.transformers.DefaultQueryTransformer;
import org.jabref.logic.importer.util.JsonReader;
import org.jabref.logic.net.URLDownload;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.ArXivIdentifier;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.model.entry.types.StandardEntryType;
import org.jabref.model.strings.StringUtil;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticScholar
implements FulltextFetcher,
PagedSearchBasedParserFetcher,
EntryBasedFetcher,
CustomizableKeyFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SemanticScholar.class);
    private static final String SOURCE_ID_SEARCH = "https://api.semanticscholar.org/v1/paper/";
    private static final String SOURCE_WEB_SEARCH = "https://api.semanticscholar.org/graph/v1/paper/search?";
    private final ImporterPreferences importerPreferences;

    public SemanticScholar(ImporterPreferences importerPreferences) {
        this.importerPreferences = importerPreferences;
    }

    @Override
    public Optional<URL> findFullText(BibEntry entry) throws IOException, FetcherException {
        Objects.requireNonNull(entry);
        Optional doi = entry.getField(StandardField.DOI).flatMap(DOI::parse);
        Optional arXiv = entry.getField(StandardField.EPRINT).flatMap(ArXivIdentifier::parse);
        Document html = null;
        if (doi.isPresent()) {
            try {
                String source = SOURCE_ID_SEARCH + ((DOI)doi.get()).getDOI();
                Connection jsoupRequest = Jsoup.connect((String)this.getURLBySource(source)).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36").header("Accept", "text/html; charset=utf-8").referrer("https://www.google.com").ignoreHttpErrors(true);
                this.importerPreferences.getApiKey(this.getName()).ifPresent(key -> jsoupRequest.header("x-api-key", key));
                html = jsoupRequest.get();
            }
            catch (IOException e) {
                LOGGER.info("Error for pdf lookup with DOI");
            }
        }
        if (arXiv.isPresent() && entry.getField(StandardField.EPRINT).isPresent()) {
            Object arXivString = entry.getField(StandardField.EPRINT).get();
            if (!((String)arXivString).startsWith("arXiv:")) {
                arXivString = "arXiv:" + (String)arXivString;
            }
            String source = SOURCE_ID_SEARCH + (String)arXivString;
            Connection jsoupRequest = Jsoup.connect((String)this.getURLBySource(source)).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36").referrer("https://www.google.com").header("Accept", "text/html; charset=utf-8").ignoreHttpErrors(true);
            this.importerPreferences.getApiKey(this.getName()).ifPresent(key -> jsoupRequest.header("x-api-key", key));
            html = jsoupRequest.get();
        }
        if (html == null) {
            return Optional.empty();
        }
        Element metaTag = html.selectFirst("meta[name=citation_pdf_url]");
        if (metaTag == null) {
            return Optional.empty();
        }
        String link = metaTag.attr("content");
        if (StringUtil.isNullOrEmpty(link)) {
            return Optional.empty();
        }
        LOGGER.info("Fulltext PDF found @ SemanticScholar. Link: {}", (Object)link);
        return Optional.of(new URL(link));
    }

    @Override
    public TrustLevel getTrustLevel() {
        return TrustLevel.META_SEARCH;
    }

    String getURLBySource(String source) throws IOException, FetcherException {
        URLDownload download = new URLDownload(source);
        JSONObject json = new JSONObject(download.asString());
        LOGGER.debug("URL for source: {}", (Object)json.get("url").toString());
        if (!json.has("url")) {
            throw new FetcherException("Page does not contain field \"url\"");
        }
        return json.get("url").toString();
    }

    @Override
    public URL getURLForQuery(QueryNode luceneQuery, int pageNumber) throws URISyntaxException, MalformedURLException, FetcherException {
        URIBuilder uriBuilder = new URIBuilder(SOURCE_WEB_SEARCH);
        uriBuilder.addParameter("query", new DefaultQueryTransformer().transformLuceneQuery(luceneQuery).orElse(""));
        uriBuilder.addParameter("offset", String.valueOf(pageNumber * this.getPageSize()));
        uriBuilder.addParameter("limit", String.valueOf(Math.min(this.getPageSize(), 10000 - pageNumber * this.getPageSize())));
        uriBuilder.addParameter("fields", "paperId,externalIds,url,title,abstract,venue,year,authors");
        LOGGER.debug("URL for query: {}", (Object)uriBuilder.build().toURL());
        return uriBuilder.build().toURL();
    }

    @Override
    public Parser getParser() {
        return inputStream -> {
            JSONObject response = JsonReader.toJsonObject(inputStream);
            LOGGER.debug("Response for Parser: {}", (Object)response);
            if (response.isEmpty()) {
                return Collections.emptyList();
            }
            int total = response.getInt("total");
            if (total == 0) {
                return Collections.emptyList();
            }
            if (response.has("next")) {
                total = Math.min(total, response.getInt("next") - response.getInt("offset"));
            }
            JSONArray items = response.getJSONArray("data");
            ArrayList<BibEntry> entries = new ArrayList<BibEntry>(items.length());
            for (int i = 0; i < total; ++i) {
                JSONObject item = items.getJSONObject(i);
                BibEntry entry = this.jsonItemToBibEntry(item);
                entries.add(entry);
            }
            return entries;
        };
    }

    private BibEntry jsonItemToBibEntry(JSONObject item) throws ParseException {
        try {
            BibEntry entry = new BibEntry(StandardEntryType.Article);
            entry.setField(StandardField.URL, item.optString("url"));
            entry.setField(StandardField.TITLE, item.optString("title"));
            entry.setField(StandardField.ABSTRACT, item.optString("abstract"));
            entry.setField(StandardField.VENUE, item.optString("venue"));
            entry.setField(StandardField.YEAR, item.optString("year"));
            entry.setField(StandardField.AUTHOR, IntStream.range(0, item.optJSONArray("authors").length()).mapToObj(arg_0 -> ((JSONArray)item.optJSONArray("authors")).getJSONObject(arg_0)).map(author -> author.has("name") ? author.getString("name") : "").collect(Collectors.joining(" and ")));
            JSONObject externalIds = item.optJSONObject("externalIds");
            entry.setField(StandardField.DOI, externalIds.optString("DOI"));
            if (externalIds.has("ArXiv")) {
                entry.setField(StandardField.EPRINT, externalIds.getString("ArXiv"));
                entry.setField(StandardField.EPRINTTYPE, "arXiv");
            }
            entry.setField(StandardField.PMID, externalIds.optString("PubMed"));
            return entry;
        }
        catch (JSONException exception) {
            throw new ParseException("SemanticScholar API JSON format has changed", exception);
        }
    }

    @Override
    public String getName() {
        return "SemanticScholar";
    }

    @Override
    public List<BibEntry> performSearch(BibEntry entry) throws FetcherException {
        Optional<String> title = entry.getTitle();
        if (title.isEmpty()) {
            return new ArrayList<BibEntry>();
        }
        return this.performSearch(title.get());
    }
}

