/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher.isbntobibtex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.importer.EntryBasedFetcher;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.IdBasedFetcher;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.fetcher.AbstractIsbnFetcher;
import org.jabref.logic.importer.fetcher.GvkFetcher;
import org.jabref.logic.importer.fetcher.isbntobibtex.OpenLibraryIsbnFetcher;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.ISBN;
import org.jabref.model.util.OptionalUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsbnFetcher
implements EntryBasedFetcher,
IdBasedFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsbnFetcher.class);
    private static final Pattern NEWLINE_SPACE_PATTERN = Pattern.compile("\\n|\\r\\n|\\s");
    protected final ImportFormatPreferences importFormatPreferences;
    private final List<AbstractIsbnFetcher> retryIsbnFetcher;
    private final GvkFetcher gvkIsbnFetcher;

    public IsbnFetcher(ImportFormatPreferences importFormatPreferences) {
        this.importFormatPreferences = importFormatPreferences;
        OpenLibraryIsbnFetcher openLibraryIsbnFetcher = new OpenLibraryIsbnFetcher(importFormatPreferences);
        this.gvkIsbnFetcher = new GvkFetcher(importFormatPreferences);
        this.retryIsbnFetcher = new ArrayList<AbstractIsbnFetcher>();
        this.addRetryFetcher(openLibraryIsbnFetcher);
    }

    @Override
    public String getName() {
        return "ISBN";
    }

    @Override
    public Optional<HelpFile> getHelpPage() {
        return Optional.of(HelpFile.FETCHER_ISBN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<BibEntry> performSearchById(String identifier) throws FetcherException {
        Optional<Object> bibEntry;
        block8: {
            bibEntry = Optional.empty();
            try {
                identifier = this.removeNewlinesAndSpacesFromIdentifier(identifier);
                Optional<ISBN> isbn = ISBN.parse(identifier);
                if (!isbn.isPresent()) break block8;
                bibEntry = this.gvkIsbnFetcher.performSearchById(isbn.get().getNormalized());
            }
            catch (FetcherException ex) {
                LOGGER.debug("Got a fetcher exception for IBSN search", (Throwable)ex);
                if (this.retryIsbnFetcher.isEmpty()) {
                    throw ex;
                }
            }
            finally {
                Iterator<AbstractIsbnFetcher> iterator = this.retryIsbnFetcher.iterator();
                while (bibEntry.isEmpty() && iterator.hasNext()) {
                    LOGGER.debug("Trying using the alternate ISBN fetchers to find an entry.");
                    AbstractIsbnFetcher fetcher = iterator.next();
                    LOGGER.debug("No entry found for ISBN {}; trying {} next.", (Object)identifier, (Object)fetcher.getName());
                    bibEntry = fetcher.performSearchById(identifier);
                }
            }
        }
        if (bibEntry.isEmpty()) {
            LOGGER.debug("Could not found a entry for ISBN {}", (Object)identifier);
        }
        return bibEntry;
    }

    @Override
    public List<BibEntry> performSearch(BibEntry entry) throws FetcherException {
        Optional<String> isbn = entry.getField(StandardField.ISBN);
        if (isbn.isPresent()) {
            return OptionalUtil.toList(this.performSearchById(isbn.get()));
        }
        return Collections.emptyList();
    }

    public IsbnFetcher addRetryFetcher(AbstractIsbnFetcher retryFetcher) {
        Objects.requireNonNull(retryFetcher, "Please provide a valid isbn fetcher.");
        this.retryIsbnFetcher.add(retryFetcher);
        return this;
    }

    private String removeNewlinesAndSpacesFromIdentifier(String identifier) {
        return NEWLINE_SPACE_PATTERN.matcher(identifier).replaceAll("");
    }
}

