/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher.transformers;

import java.util.Calendar;
import java.util.Optional;
import kong.unirest.core.json.JSONArray;
import kong.unirest.core.json.JSONObject;
import org.jabref.logic.importer.fetcher.transformers.AbstractQueryTransformer;
import org.jabref.model.strings.StringUtil;

public class CiteSeerQueryTransformer
extends AbstractQueryTransformer {
    private JSONObject payload = new JSONObject();

    public CiteSeerQueryTransformer() {
        this.handlePage("1");
        this.handlePageSize("20");
        this.getJSONPayload().put("must_have_pdf", "false");
        this.handleSortBy("relevance");
    }

    @Override
    protected String getLogicalAndOperator() {
        return " ";
    }

    @Override
    protected String getLogicalOrOperator() {
        return " ";
    }

    @Override
    protected String getLogicalNotOperator() {
        return "";
    }

    @Override
    protected String handleAuthor(String author) {
        if (!this.getJSONPayload().has("author")) {
            this.getJSONPayload().put("author", new JSONArray());
        }
        this.getJSONPayload().getJSONArray("author").put(author).toString();
        return StringUtil.quoteStringIfSpaceIsContained(author);
    }

    @Override
    protected String handleTitle(String title) {
        this.getJSONPayload().put("queryString", title);
        return StringUtil.quoteStringIfSpaceIsContained(title);
    }

    @Override
    protected String handleJournal(String journalTitle) {
        this.getJSONPayload().put("journal", journalTitle);
        return StringUtil.quoteStringIfSpaceIsContained(journalTitle);
    }

    @Override
    protected String handleYear(String year) {
        this.getJSONPayload().put("yearStart", Integer.parseInt(year));
        this.getJSONPayload().put("yearEnd", Integer.parseInt(year));
        return StringUtil.quoteStringIfSpaceIsContained(year);
    }

    @Override
    protected String handleYearRange(String yearRange) {
        this.parseYearRange(yearRange);
        if (this.endYear == Integer.MAX_VALUE) {
            Calendar calendar = Calendar.getInstance();
            this.getJSONPayload().put("yearEnd", calendar.get(1));
            return "";
        }
        this.getJSONPayload().put("yearStart", this.startYear);
        this.getJSONPayload().put("yearEnd", this.endYear);
        return yearRange;
    }

    @Override
    protected Optional<String> handleOtherField(String fieldAsString, String term) {
        return switch (fieldAsString) {
            case "page" -> this.handlePage(term);
            case "pageSize" -> this.handlePageSize(term);
            case "must_have_pdf" -> this.handleMustHavePdf(term);
            case "sortBy" -> this.handleSortBy(term);
            default -> super.handleOtherField(fieldAsString, term);
        };
    }

    private Optional<String> handlePage(String page) {
        this.getJSONPayload().put("page", StringUtil.intValueOf(page));
        return Optional.of(page);
    }

    private Optional<String> handlePageSize(String pageSize) {
        this.getJSONPayload().put("pageSize", StringUtil.intValueOf(pageSize));
        return Optional.of(pageSize);
    }

    private Optional<String> handleMustHavePdf(String mustHavePdf) {
        this.getJSONPayload().put("must_have_pdf", mustHavePdf);
        return Optional.of(mustHavePdf);
    }

    private Optional<String> handleSortBy(String sortBy) {
        this.getJSONPayload().put("sortBy", sortBy);
        return Optional.of(sortBy);
    }

    public JSONObject getJSONPayload() {
        return this.payload;
    }
}

