/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher.transformers;

import java.util.Optional;
import org.jabref.logic.importer.fetcher.transformers.YearRangeByFilteringQueryTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GVKQueryTransformer
extends YearRangeByFilteringQueryTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GVKQueryTransformer.class);

    @Override
    protected String getLogicalAndOperator() {
        return " and ";
    }

    @Override
    protected String getLogicalOrOperator() {
        LOGGER.warn("GVK does not support Boolean OR operator");
        return " ";
    }

    @Override
    protected String getLogicalNotOperator() {
        LOGGER.warn("GVK does not support Boolean NOT operator");
        return " ";
    }

    @Override
    protected String handleAuthor(String author) {
        return this.createKeyValuePair("pica.per", author, "=");
    }

    @Override
    protected String handleTitle(String title) {
        return this.createKeyValuePair("pica.tit", title, "=");
    }

    @Override
    protected String handleJournal(String journalTitle) {
        return this.createKeyValuePair("pica.zti", journalTitle, "=");
    }

    @Override
    protected String handleYear(String year) {
        return "pica.erj=" + year;
    }

    @Override
    protected Optional<String> handleUnFieldedTerm(String term) {
        return Optional.of(this.createKeyValuePair("pica.all", term, "="));
    }

    @Override
    protected Optional<String> handleOtherField(String fieldAsString, String term) {
        return Optional.of(this.createKeyValuePair("pica." + fieldAsString, term, "="));
    }
}

