/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher.transformers;

import org.jabref.logic.importer.fetcher.transformers.AbstractQueryTransformer;

public class JstorQueryTransformer
extends AbstractQueryTransformer {
    @Override
    protected String getLogicalAndOperator() {
        return " AND ";
    }

    @Override
    protected String getLogicalOrOperator() {
        return " OR ";
    }

    @Override
    protected String getLogicalNotOperator() {
        return "NOT ";
    }

    @Override
    protected String handleAuthor(String author) {
        return this.createKeyValuePair("au", author);
    }

    @Override
    protected String handleTitle(String title) {
        return this.createKeyValuePair("ti", title);
    }

    @Override
    protected String handleJournal(String journalTitle) {
        return this.createKeyValuePair("pt", journalTitle);
    }

    @Override
    protected String handleYear(String year) {
        return "sd:" + year + this.getLogicalAndOperator() + "ed: " + year;
    }

    @Override
    protected String handleYearRange(String yearRange) {
        this.parseYearRange(yearRange);
        if (this.endYear == Integer.MAX_VALUE) {
            return yearRange;
        }
        return "sd:" + this.startYear + this.getLogicalAndOperator() + "ed:" + this.endYear;
    }
}

