/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.StandardEntryType;

public class BiblioscapeImporter
extends Importer {
    @Override
    public String getName() {
        return "Biblioscape";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.TXT;
    }

    @Override
    public String getDescription() {
        return "Imports a Biblioscape Tag File.\nSeveral Biblioscape field types are ignored. Others are only included in the BibTeX field \"comment\".";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) {
        Objects.requireNonNull(reader);
        return true;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String line;
        ArrayList<BibEntry> bibItems = new ArrayList<BibEntry>();
        HashMap<Field, String> hm = new HashMap<Field, String>();
        HashMap<String, StringBuilder> lines = new HashMap<String, StringBuilder>();
        StringBuilder previousLine = null;
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty()) continue;
            if ("------".equals(line)) {
                String[] type = new String[2];
                String[] pages = new String[2];
                String country = null;
                String address = null;
                String titleST = null;
                String titleTI = null;
                ArrayList<CallSite> comments = new ArrayList<CallSite>();
                for (Map.Entry entry : lines.entrySet()) {
                    if ("AU".equals(entry.getKey())) {
                        hm.put(StandardField.AUTHOR, ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("TI".equals(entry.getKey())) {
                        titleTI = ((StringBuilder)entry.getValue()).toString();
                        continue;
                    }
                    if ("ST".equals(entry.getKey())) {
                        titleST = ((StringBuilder)entry.getValue()).toString();
                        continue;
                    }
                    if ("YP".equals(entry.getKey())) {
                        hm.put(StandardField.YEAR, ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("VL".equals(entry.getKey())) {
                        hm.put(StandardField.VOLUME, ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("NB".equals(entry.getKey())) {
                        hm.put(StandardField.NUMBER, ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("PS".equals(entry.getKey())) {
                        pages[0] = ((StringBuilder)entry.getValue()).toString();
                        continue;
                    }
                    if ("PE".equals(entry.getKey())) {
                        pages[1] = ((StringBuilder)entry.getValue()).toString();
                        continue;
                    }
                    if ("KW".equals(entry.getKey())) {
                        hm.put(StandardField.KEYWORDS, ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("RT".equals(entry.getKey())) {
                        type[0] = ((StringBuilder)entry.getValue()).toString();
                        continue;
                    }
                    if ("SB".equals(entry.getKey())) {
                        comments.add((CallSite)((Object)("Subject: " + String.valueOf(entry.getValue()))));
                        continue;
                    }
                    if ("SA".equals(entry.getKey())) {
                        comments.add((CallSite)((Object)("Secondary Authors: " + String.valueOf(entry.getValue()))));
                        continue;
                    }
                    if ("NT".equals(entry.getKey())) {
                        hm.put(StandardField.NOTE, ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("PB".equals(entry.getKey())) {
                        hm.put(StandardField.PUBLISHER, ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("TA".equals(entry.getKey())) {
                        comments.add((CallSite)((Object)("Tertiary Authors: " + String.valueOf(entry.getValue()))));
                        continue;
                    }
                    if ("TT".equals(entry.getKey())) {
                        comments.add((CallSite)((Object)("Tertiary Title: " + String.valueOf(entry.getValue()))));
                        continue;
                    }
                    if ("ED".equals(entry.getKey())) {
                        hm.put(StandardField.EDITION, ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("TW".equals(entry.getKey())) {
                        type[1] = ((StringBuilder)entry.getValue()).toString();
                        continue;
                    }
                    if ("QA".equals(entry.getKey())) {
                        comments.add((CallSite)((Object)("Quaternary Authors: " + String.valueOf(entry.getValue()))));
                        continue;
                    }
                    if ("QT".equals(entry.getKey())) {
                        comments.add((CallSite)((Object)("Quaternary Title: " + String.valueOf(entry.getValue()))));
                        continue;
                    }
                    if ("IS".equals(entry.getKey())) {
                        hm.put(StandardField.ISBN, ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("AB".equals(entry.getKey())) {
                        hm.put(StandardField.ABSTRACT, ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("AD".equals(entry.getKey())) {
                        address = ((StringBuilder)entry.getValue()).toString();
                        continue;
                    }
                    if ("LG".equals(entry.getKey())) {
                        hm.put(StandardField.LANGUAGE, ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("CO".equals(entry.getKey())) {
                        country = ((StringBuilder)entry.getValue()).toString();
                        continue;
                    }
                    if ("UR".equals(entry.getKey()) || "AT".equals(entry.getKey())) {
                        String s = ((StringBuilder)entry.getValue()).toString().trim();
                        hm.put(s.startsWith("http://") || s.startsWith("ftp://") ? StandardField.URL : StandardField.PDF, ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("C1".equals(entry.getKey())) {
                        comments.add((CallSite)((Object)("Custom1: " + String.valueOf(entry.getValue()))));
                        continue;
                    }
                    if ("C2".equals(entry.getKey())) {
                        comments.add((CallSite)((Object)("Custom2: " + String.valueOf(entry.getValue()))));
                        continue;
                    }
                    if ("C3".equals(entry.getKey())) {
                        comments.add((CallSite)((Object)("Custom3: " + String.valueOf(entry.getValue()))));
                        continue;
                    }
                    if ("C4".equals(entry.getKey())) {
                        comments.add((CallSite)((Object)("Custom4: " + String.valueOf(entry.getValue()))));
                        continue;
                    }
                    if ("C5".equals(entry.getKey())) {
                        comments.add((CallSite)((Object)("Custom5: " + String.valueOf(entry.getValue()))));
                        continue;
                    }
                    if ("C6".equals(entry.getKey())) {
                        comments.add((CallSite)((Object)("Custom6: " + String.valueOf(entry.getValue()))));
                        continue;
                    }
                    if ("DE".equals(entry.getKey())) {
                        hm.put(StandardField.ANNOTE, ((StringBuilder)entry.getValue()).toString());
                        continue;
                    }
                    if ("CA".equals(entry.getKey())) {
                        comments.add((CallSite)((Object)("Categories: " + String.valueOf(entry.getValue()))));
                        continue;
                    }
                    if ("TH".equals(entry.getKey())) {
                        comments.add((CallSite)((Object)("Short Title: " + String.valueOf(entry.getValue()))));
                        continue;
                    }
                    if (!"SE".equals(entry.getKey())) continue;
                    hm.put(StandardField.CHAPTER, ((StringBuilder)entry.getValue()).toString());
                }
                EntryType bibtexType = BibEntry.DEFAULT_TYPE;
                for (int i = 1; i >= 0 && BibEntry.DEFAULT_TYPE.equals(bibtexType); --i) {
                    if (type[i] == null) continue;
                    type[i] = type[i].toLowerCase(Locale.ROOT);
                    if (type[i].contains("article")) {
                        bibtexType = StandardEntryType.Article;
                        continue;
                    }
                    if (type[i].contains("journal")) {
                        bibtexType = StandardEntryType.Article;
                        continue;
                    }
                    if (type[i].contains("book section")) {
                        bibtexType = StandardEntryType.InBook;
                        continue;
                    }
                    if (type[i].contains("book")) {
                        bibtexType = StandardEntryType.Book;
                        continue;
                    }
                    if (type[i].contains("conference")) {
                        bibtexType = StandardEntryType.InProceedings;
                        continue;
                    }
                    if (type[i].contains("proceedings")) {
                        bibtexType = StandardEntryType.InProceedings;
                        continue;
                    }
                    if (type[i].contains("report")) {
                        bibtexType = StandardEntryType.TechReport;
                        continue;
                    }
                    if (type[i].contains("thesis") && type[i].contains("master")) {
                        bibtexType = StandardEntryType.MastersThesis;
                        continue;
                    }
                    if (!type[i].contains("thesis")) continue;
                    bibtexType = StandardEntryType.PhdThesis;
                }
                if (bibtexType.equals(StandardEntryType.Article)) {
                    if (titleST != null) {
                        hm.put(StandardField.JOURNAL, titleST);
                    }
                    if (titleTI != null) {
                        hm.put(StandardField.TITLE, titleTI);
                    }
                } else if (bibtexType.equals(StandardEntryType.InBook)) {
                    if (titleST != null) {
                        hm.put(StandardField.BOOKTITLE, titleST);
                    }
                    if (titleTI != null) {
                        hm.put(StandardField.TITLE, titleTI);
                    }
                } else {
                    if (titleST != null) {
                        hm.put(StandardField.BOOKTITLE, titleST);
                    }
                    if (titleTI != null) {
                        hm.put(StandardField.TITLE, titleTI);
                    }
                }
                if (pages[0] != null || pages[1] != null) {
                    hm.put(StandardField.PAGES, (pages[0] == null ? "" : pages[0]) + (String)(pages[1] == null ? "" : "--" + pages[1]));
                }
                if (address != null) {
                    hm.put(StandardField.ADDRESS, address + (String)(country == null ? "" : ", " + country));
                }
                if (!comments.isEmpty()) {
                    hm.put(StandardField.COMMENT, String.join((CharSequence)";", comments));
                }
                BibEntry b = new BibEntry(bibtexType);
                b.setField(hm);
                bibItems.add(b);
                hm.clear();
                lines.clear();
                previousLine = null;
                continue;
            }
            if (line.startsWith("--") && line.length() >= 7 && "-- ".equals(line.substring(4, 7))) {
                previousLine = new StringBuilder(line.substring(7));
                lines.put(line.substring(2, 4), previousLine);
                continue;
            }
            if (previousLine == null) {
                return new ParserResult();
            }
            previousLine.append(line.trim());
        }
        return new ParserResult(bibItems);
    }
}

