/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.KeywordList;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.IEEETranEntryType;
import org.jabref.model.entry.types.StandardEntryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndnoteXmlImporter
extends Importer
implements Parser {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndnoteXmlImporter.class);
    private static final Map<EntryType, String> ENTRY_TYPE_MAPPING = Map.ofEntries(Map.entry(StandardEntryType.Article, "Journal Article"), Map.entry(StandardEntryType.Book, "Book"), Map.entry(StandardEntryType.InBook, "Book Section"), Map.entry(StandardEntryType.InCollection, "Book Section"), Map.entry(StandardEntryType.Proceedings, "Conference Proceedings"), Map.entry(StandardEntryType.MastersThesis, "Thesis"), Map.entry(StandardEntryType.PhdThesis, "Thesis"), Map.entry(StandardEntryType.TechReport, "Report"), Map.entry(StandardEntryType.Unpublished, "Manuscript"), Map.entry(StandardEntryType.InProceedings, "Conference Paper"), Map.entry(StandardEntryType.Conference, "Conference"), Map.entry(IEEETranEntryType.Patent, "Patent"), Map.entry(StandardEntryType.Online, "Web Page"), Map.entry(IEEETranEntryType.Electronic, "Electronic Article"), Map.entry(StandardEntryType.Misc, "Generic"));
    private static final Map<Field, String> FIELD_MAPPING = Map.ofEntries(Map.entry(StandardField.TITLE, "title"), Map.entry(StandardField.AUTHOR, "authors"), Map.entry(StandardField.EDITOR, "secondary-authors"), Map.entry(StandardField.BOOKTITLE, "secondary-title"), Map.entry(StandardField.EDITION, "edition"), Map.entry(StandardField.SERIES, "tertiary-title"), Map.entry(StandardField.VOLUME, "volume"), Map.entry(StandardField.NUMBER, "number"), Map.entry(StandardField.ISSUE, "issue"), Map.entry(StandardField.PAGES, "pages"), Map.entry(StandardField.LOCATION, "pub-location"), Map.entry(StandardField.CHAPTER, "section"), Map.entry(StandardField.HOWPUBLISHED, "work-type"), Map.entry(StandardField.PUBLISHER, "publisher"), Map.entry(StandardField.ISBN, "isbn"), Map.entry(StandardField.ISSN, "issn"), Map.entry(StandardField.DOI, "electronic-resource-num"), Map.entry(StandardField.URL, "web-urls"), Map.entry(StandardField.FILE, "pdf-urls"), Map.entry(StandardField.ABSTRACT, "abstract"), Map.entry(StandardField.KEYWORDS, "keywords"), Map.entry(StandardField.PAGETOTAL, "page-total"), Map.entry(StandardField.NOTE, "notes"), Map.entry(StandardField.LANGUAGE, "language"), Map.entry(StandardField.ADDRESS, "auth-address"));
    private static final UnknownField FIELD_ALT_TITLE = new UnknownField("alt-title");
    private final ImportFormatPreferences preferences;
    private final XMLInputFactory xmlInputFactory;

    public EndnoteXmlImporter(ImportFormatPreferences preferences) {
        this.preferences = preferences;
        this.xmlInputFactory = XMLInputFactory.newInstance();
        this.xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
    }

    @Override
    public String getName() {
        return "EndNote XML";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.XML;
    }

    @Override
    public String getId() {
        return "endnote";
    }

    @Override
    public String getDescription() {
        return "Importer for the EndNote XML format.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        for (int i = 0; (str = reader.readLine()) != null && i < 50; ++i) {
            if (!str.toLowerCase(Locale.ENGLISH).contains("<records>")) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParserResult importDatabase(BufferedReader input) throws IOException {
        Objects.requireNonNull(input);
        ArrayList<BibEntry> bibItems = new ArrayList<BibEntry>();
        try {
            XMLStreamReader reader = this.xmlInputFactory.createXMLStreamReader(input);
            while (reader.hasNext()) {
                reader.next();
                if (!this.isStartElement(reader, "record")) continue;
                BibEntry entry = this.parseRecord(reader);
                bibItems.add(entry);
            }
        }
        catch (XMLStreamException e) {
            LOGGER.debug("could not parse document", (Throwable)e);
            return ParserResult.fromError(e);
        }
        return new ParserResult(bibItems);
    }

    private BibEntry parseRecord(XMLStreamReader reader) throws XMLStreamException {
        String altTitle;
        BibEntry entry = new BibEntry();
        block18: while (reader.hasNext()) {
            String elementName;
            reader.next();
            if (this.isEndElement(reader, "record")) break;
            if (!this.isStartElement(reader)) continue;
            switch (elementName = reader.getName().getLocalPart()) {
                case "ref-type": {
                    String refType = reader.getAttributeValue(null, "name");
                    EntryType entryType = ENTRY_TYPE_MAPPING.entrySet().stream().filter(e -> ((String)e.getValue()).equals(refType)).map(Map.Entry::getKey).findFirst().orElse(StandardEntryType.Misc);
                    entry.setType(entryType);
                    continue block18;
                }
                case "contributors": {
                    this.parseContributors(reader, entry);
                    continue block18;
                }
                case "titles": {
                    this.parseTitles(reader, entry);
                    continue block18;
                }
                case "periodical": {
                    this.parsePeriodical(reader, entry);
                    continue block18;
                }
                case "keywords": {
                    this.parseKeywords(reader, entry);
                    continue block18;
                }
                case "urls": {
                    this.parseUrls(reader, entry);
                    continue block18;
                }
                case "dates": {
                    this.parseDates(reader, entry);
                    continue block18;
                }
            }
            Field field = FIELD_MAPPING.entrySet().stream().filter(e -> ((String)e.getValue()).equals(elementName)).map(Map.Entry::getKey).findFirst().orElse(null);
            if (field == null) continue;
            String value = this.parseElementContent(reader, elementName);
            entry.setField(field, value);
        }
        String journalOrBooktitle = entry.getField(StandardField.JOURNAL).or(() -> entry.getField(StandardField.BOOKTITLE)).orElse("");
        if (entry.hasField(FIELD_ALT_TITLE) && journalOrBooktitle.equals(altTitle = entry.getField(FIELD_ALT_TITLE).orElse(""))) {
            entry.clearField(FIELD_ALT_TITLE);
        }
        return entry;
    }

    private void parseContributors(XMLStreamReader reader, BibEntry entry) throws XMLStreamException {
        while (reader.hasNext()) {
            reader.next();
            if (this.isEndElement(reader, "contributors")) break;
            this.extractPersons(reader, "authors", entry, StandardField.AUTHOR);
            this.extractPersons(reader, "secondary-authors", entry, StandardField.EDITOR);
        }
    }

    private void extractPersons(XMLStreamReader reader, String elementName, BibEntry entry, StandardField author) throws XMLStreamException {
        if (this.isStartElement(reader, elementName)) {
            StringJoiner persons = new StringJoiner(" and ");
            while (reader.hasNext()) {
                String person;
                reader.next();
                if (this.isEndElement(reader, elementName)) break;
                if (!this.isStartElement(reader, "author") || (person = this.parseElementContent(reader, "author")).isEmpty()) continue;
                persons.add(person);
            }
            entry.setField(author, persons.toString());
        }
    }

    private void parseTitles(XMLStreamReader reader, BibEntry entry) throws XMLStreamException {
        while (reader.hasNext()) {
            String elementName;
            reader.next();
            if (this.isEndElement(reader, "titles")) break;
            if (!this.isStartElement(reader)) continue;
            switch (elementName = reader.getName().getLocalPart()) {
                case "title": {
                    String title = this.parseElementContent(reader, "title");
                    entry.setField(StandardField.TITLE, title);
                    break;
                }
                case "secondary-title": {
                    String secondaryTitle = this.parseElementContent(reader, "secondary-title");
                    if (entry.getType().equals(StandardEntryType.Article)) {
                        entry.setField(StandardField.JOURNAL, secondaryTitle);
                        break;
                    }
                    entry.setField(StandardField.BOOKTITLE, secondaryTitle);
                    break;
                }
                case "alt-title": {
                    String altTitle = this.parseElementContent(reader, "alt-title");
                    entry.setField(FIELD_ALT_TITLE, altTitle);
                }
            }
        }
    }

    private void parsePeriodical(XMLStreamReader reader, BibEntry entry) throws XMLStreamException {
        while (reader.hasNext()) {
            reader.next();
            if (this.isEndElement(reader, "periodical")) break;
            if (!this.isStartElement(reader)) continue;
            this.parseJournalOrBookTitle(reader, entry);
        }
    }

    private void parseJournalOrBookTitle(XMLStreamReader reader, BibEntry entry) throws XMLStreamException {
        String elementName;
        switch (elementName = reader.getName().getLocalPart()) {
            case "full-title": 
            case "abbr-2": 
            case "abbr-1": 
            case "abbr-3": {
                String title = this.parseElementContent(reader, elementName);
                if (entry.getType().equals(StandardEntryType.Article)) {
                    entry.setField(StandardField.JOURNAL, title);
                    break;
                }
                entry.setField(StandardField.BOOKTITLE, title);
            }
        }
    }

    private void parseKeywords(XMLStreamReader reader, BibEntry entry) throws XMLStreamException {
        KeywordList keywordList = new KeywordList();
        while (reader.hasNext()) {
            String keyword;
            reader.next();
            if (this.isEndElement(reader, "keywords")) break;
            if (!this.isStartElement(reader, "keyword") || (keyword = this.parseElementContent(reader, "keyword")).isEmpty()) continue;
            keywordList.add(keyword);
        }
        if (!keywordList.isEmpty()) {
            entry.putKeywords(keywordList, this.preferences.bibEntryPreferences().getKeywordSeparator());
        }
    }

    private void parseUrls(XMLStreamReader reader, BibEntry entry) throws XMLStreamException {
        while (reader.hasNext()) {
            String elementName;
            reader.next();
            if (this.isEndElement(reader, "urls")) break;
            if (!this.isStartElement(reader)) continue;
            block5 : switch (elementName = reader.getName().getLocalPart()) {
                case "web-urls": {
                    String url;
                    while (reader.hasNext()) {
                        reader.next();
                        if (this.isEndElement(reader, "web-urls")) break block5;
                        if (!this.isStartElement(reader, "url")) continue;
                        url = this.parseElementContent(reader, "url");
                        entry.setField(StandardField.URL, url);
                    }
                    break;
                }
                case "pdf-urls": {
                    while (reader.hasNext()) {
                        reader.next();
                        if (this.isEndElement(reader, "pdf-urls")) break block5;
                        if (!this.isStartElement(reader, "url")) continue;
                        String file = this.parseElementContent(reader, "url");
                        entry.setField(StandardField.FILE, file);
                    }
                    break;
                }
                case "related-urls": {
                    String url;
                    while (reader.hasNext()) {
                        reader.next();
                        if (this.isEndElement(reader, "related-urls")) break block5;
                        if (!this.isStartElement(reader, "url")) continue;
                        url = this.clean(this.parseElementContent(reader, "url"));
                        entry.setField(StandardField.URL, url);
                    }
                    break;
                }
            }
        }
    }

    private void parseDates(XMLStreamReader reader, BibEntry entry) throws XMLStreamException {
        while (reader.hasNext()) {
            String elementName;
            reader.next();
            if (this.isEndElement(reader, "dates")) break;
            if (!this.isStartElement(reader)) continue;
            block6 : switch (elementName = reader.getName().getLocalPart()) {
                case "year": 
                case "month": 
                case "day": {
                    String date = this.parseElementContent(reader, elementName);
                    entry.setField(StandardField.fromName(elementName).get(), date);
                    break;
                }
                case "pub-dates": {
                    while (reader.hasNext()) {
                        reader.next();
                        if (this.isEndElement(reader, "pub-dates")) break block6;
                        if (!this.isStartElement(reader, "date")) continue;
                        String pubDate = this.parseElementContent(reader, "date");
                        entry.setField(StandardField.DATE, pubDate);
                    }
                    break;
                }
            }
        }
    }

    private String parseElementContent(XMLStreamReader reader, String elementName) throws XMLStreamException {
        StringBuilder content = new StringBuilder();
        while (reader.hasNext()) {
            reader.next();
            if (this.isEndElement(reader, elementName)) break;
            if (this.isStartElement(reader, "style")) {
                content.append(reader.getElementText()).append(" ");
                continue;
            }
            if (reader.getEventType() != 4) continue;
            content.append(reader.getText());
        }
        return this.clean(content.toString());
    }

    private String clean(String input) {
        return input.trim().replaceAll("\\s+", " ");
    }

    private boolean isStartElement(XMLStreamReader reader, String elementName) {
        return this.isStartElement(reader) && reader.getName().getLocalPart().equals(elementName);
    }

    private boolean isStartElement(XMLStreamReader reader) {
        return reader.getEventType() == 1;
    }

    private boolean isEndElement(XMLStreamReader reader, String elementName) {
        return this.isEndElement(reader) && reader.getName().getLocalPart().equals(elementName);
    }

    private boolean isEndElement(XMLStreamReader reader) {
        return reader.getEventType() == 2;
    }

    @Override
    public List<BibEntry> parseEntries(InputStream inputStream) throws ParseException {
        try {
            return this.importDatabase(new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8))).getDatabase().getEntries();
        }
        catch (IOException e) {
            LOGGER.error("Could not import file", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

