/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kong.unirest.core.json.JSONException;
import kong.unirest.core.json.JSONObject;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrDLibImporter
extends Importer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MrDLibImporter.class);
    public ParserResult parserResult;
    private String recommendationsHeading;
    private String recommendationsDescription;
    private String recommendationSetId;

    @Override
    public boolean isRecognizedFormat(BufferedReader input) throws IOException {
        String recommendationsAsString = this.convertToString(input);
        try {
            JSONObject jsonObject = new JSONObject(recommendationsAsString);
            if (!jsonObject.has("recommendations")) {
                return false;
            }
        }
        catch (JSONException ex) {
            return false;
        }
        return true;
    }

    @Override
    public ParserResult importDatabase(BufferedReader input) throws IOException {
        this.parse(input);
        return this.parserResult;
    }

    @Override
    public String getName() {
        return "MrDLibImporter";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.JSON;
    }

    @Override
    public String getDescription() {
        return "Takes valid JSON documents from the Mr. DLib API and parses them into a BibEntry";
    }

    private String convertToString(BufferedReader input) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            while ((line = input.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return stringBuilder.toString();
    }

    private void parse(BufferedReader input) throws IOException {
        BibDatabase bibDatabase = new BibDatabase();
        String recommendationSet = this.convertToString(input);
        JSONObject recommendationSetJson = new JSONObject(recommendationSet);
        ArrayList<RankedBibEntry> rankedBibEntries = new ArrayList<RankedBibEntry>();
        JSONObject recommendationsJson = recommendationSetJson.getJSONObject("recommendations");
        Iterator keys = recommendationsJson.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            JSONObject value = recommendationsJson.getJSONObject(key);
            rankedBibEntries.add(this.populateBibEntry(value));
        }
        rankedBibEntries.sort((rankedBibEntry1, rankedBibEntry2) -> rankedBibEntry1.rank.compareTo(rankedBibEntry2.rank));
        List<BibEntry> bibEntries = rankedBibEntries.stream().map(e -> e.entry).collect(Collectors.toList());
        bibDatabase.insertEntries(bibEntries);
        this.parserResult = new ParserResult(bibDatabase);
        JSONObject label = recommendationSetJson.getJSONObject("label");
        this.recommendationsHeading = label.getString("label-text");
        this.recommendationsDescription = label.getString("label-description");
        this.recommendationSetId = recommendationSetJson.getBigInteger("recommendation_set_id").toString();
    }

    private RankedBibEntry populateBibEntry(JSONObject recommendation) {
        BibEntry current = new BibEntry();
        String authors = this.isRecommendationFieldPresent(recommendation, "authors") != false ? recommendation.getString("authors") : "";
        String title = this.isRecommendationFieldPresent(recommendation, "title") != false ? recommendation.getString("title") : "";
        String year = this.isRecommendationFieldPresent(recommendation, "published_year") != false ? Integer.toString(recommendation.getInt("published_year")) : "";
        String journal = this.isRecommendationFieldPresent(recommendation, "published_in") != false ? recommendation.getString("published_in") : "";
        String url = this.isRecommendationFieldPresent(recommendation, "url") != false ? recommendation.getString("url") : "";
        Integer rank = this.isRecommendationFieldPresent(recommendation, "recommendation_id") != false ? recommendation.getInt("recommendation_id") : 100;
        current.setField(StandardField.AUTHOR, authors);
        current.setField(StandardField.TITLE, title);
        current.setField(StandardField.YEAR, year);
        current.setField(StandardField.JOURNAL, journal);
        current.setField(StandardField.URL, url);
        return new RankedBibEntry(current, rank);
    }

    private Boolean isRecommendationFieldPresent(JSONObject recommendation, String field) {
        return recommendation.has(field) && !recommendation.isNull(field);
    }

    public ParserResult getParserResult() {
        return this.parserResult;
    }

    public String getRecommendationsHeading() {
        return this.recommendationsHeading;
    }

    public String getRecommendationsDescription() {
        return this.recommendationsDescription;
    }

    public String getRecommendationSetId() {
        return this.recommendationSetId;
    }

    private static class RankedBibEntry {
        public BibEntry entry;
        public Integer rank;

        public RankedBibEntry(BibEntry entry, Integer rank) {
            this.rank = rank;
            this.entry = entry;
        }
    }
}

