/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.EntryTypeFactory;
import org.jabref.model.entry.types.StandardEntryType;

public class OvidImporter
extends Importer {
    private static final Pattern OVID_SOURCE_PATTERN = Pattern.compile("Source ([ \\w&\\-,:]+)\\.[ ]+([0-9]+)\\(([\\w\\-]+)\\):([0-9]+\\-?[0-9]+?)\\,.*([0-9][0-9][0-9][0-9])");
    private static final Pattern OVID_SOURCE_PATTERN_NO_ISSUE = Pattern.compile("Source ([ \\w&\\-,:]+)\\.[ ]+([0-9]+):([0-9]+\\-?[0-9]+?)\\,.*([0-9][0-9][0-9][0-9])");
    private static final Pattern OVID_SOURCE_PATTERN_2 = Pattern.compile("([ \\w&\\-,]+)\\. Vol ([0-9]+)\\(([\\w\\-]+)\\) ([A-Za-z]+) ([0-9][0-9][0-9][0-9]), ([0-9]+\\-?[0-9]+)");
    private static final Pattern INCOLLECTION_PATTERN = Pattern.compile("(.+)\\(([0-9][0-9][0-9][0-9])\\)\\. ([ \\w&\\-,:]+)\\.[ ]+\\(pp. ([0-9]+\\-?[0-9]+?)\\).[A-Za-z0-9, ]+pp\\. ([\\w, ]+): ([\\w, ]+)");
    private static final Pattern BOOK_PATTERN = Pattern.compile("\\(([0-9][0-9][0-9][0-9])\\)\\. [A-Za-z, ]+([0-9]+) pp\\. ([\\w, ]+): ([\\w, ]+)");
    private static final String OVID_PATTERN_STRING = "<[0-9]+>";
    private static final Pattern OVID_PATTERN = Pattern.compile("<[0-9]+>");
    private static final int MAX_ITEMS = 50;

    @Override
    public String getName() {
        return "Ovid";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.TXT;
    }

    @Override
    public String getDescription() {
        return "Imports an Ovid file.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        for (int i = 0; (str = reader.readLine()) != null && i < 50; ++i) {
            if (!OVID_PATTERN.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String line;
        ArrayList<BibEntry> bibitems = new ArrayList<BibEntry>();
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (!line.isEmpty() && line.charAt(0) != ' ') {
                sb.append("__NEWFIELD__");
            }
            sb.append(line);
            sb.append('\n');
        }
        String[] items = sb.toString().split(OVID_PATTERN_STRING);
        for (int i = 1; i < items.length; ++i) {
            String[] fields;
            HashMap<Field, String> h = new HashMap<Field, String>();
            for (String field : fields = items[i].split("__NEWFIELD__")) {
                boolean isAuthor;
                int linebreak = field.indexOf(10);
                String fieldName = field.substring(0, linebreak).trim();
                String content = field.substring(linebreak).trim();
                boolean bl = isAuthor = fieldName.indexOf("Author") == 0 && !fieldName.contains("Author Keywords") && !fieldName.contains("Author e-mail");
                if (!isAuthor && content.endsWith(".")) {
                    content = content.substring(0, content.length() - 1);
                }
                if (isAuthor) {
                    h.put(StandardField.AUTHOR, content);
                    continue;
                }
                if (fieldName.startsWith("Title")) {
                    if ((content = content.replaceAll("\\[.+\\]", "").trim()).endsWith(".")) {
                        content = content.substring(0, content.length() - 1);
                    }
                    h.put(StandardField.TITLE, content);
                    continue;
                }
                if (fieldName.startsWith("Chapter Title")) {
                    h.put(new UnknownField("chaptertitle"), content);
                    continue;
                }
                if (fieldName.startsWith("Source")) {
                    Matcher matcher = OVID_SOURCE_PATTERN.matcher(content);
                    if (matcher.find()) {
                        h.put(StandardField.JOURNAL, matcher.group(1));
                        h.put(StandardField.VOLUME, matcher.group(2));
                        h.put(StandardField.ISSUE, matcher.group(3));
                        h.put(StandardField.PAGES, matcher.group(4));
                        h.put(StandardField.YEAR, matcher.group(5));
                    } else {
                        matcher = OVID_SOURCE_PATTERN_NO_ISSUE.matcher(content);
                        if (matcher.find()) {
                            h.put(StandardField.JOURNAL, matcher.group(1));
                            h.put(StandardField.VOLUME, matcher.group(2));
                            h.put(StandardField.PAGES, matcher.group(3));
                            h.put(StandardField.YEAR, matcher.group(4));
                        } else {
                            matcher = OVID_SOURCE_PATTERN_2.matcher(content);
                            if (matcher.find()) {
                                h.put(StandardField.JOURNAL, matcher.group(1));
                                h.put(StandardField.VOLUME, matcher.group(2));
                                h.put(StandardField.ISSUE, matcher.group(3));
                                h.put(StandardField.MONTH, matcher.group(4));
                                h.put(StandardField.YEAR, matcher.group(5));
                                h.put(StandardField.PAGES, matcher.group(6));
                            } else {
                                matcher = INCOLLECTION_PATTERN.matcher(content);
                                if (matcher.find()) {
                                    h.put(StandardField.EDITOR, matcher.group(1).replace(" (Ed)", ""));
                                    h.put(StandardField.YEAR, matcher.group(2));
                                    h.put(StandardField.BOOKTITLE, matcher.group(3));
                                    h.put(StandardField.PAGES, matcher.group(4));
                                    h.put(StandardField.ADDRESS, matcher.group(5));
                                    h.put(StandardField.PUBLISHER, matcher.group(6));
                                } else {
                                    matcher = BOOK_PATTERN.matcher(content);
                                    if (matcher.find()) {
                                        h.put(StandardField.YEAR, matcher.group(1));
                                        h.put(StandardField.PAGES, matcher.group(2));
                                        h.put(StandardField.ADDRESS, matcher.group(3));
                                        h.put(StandardField.PUBLISHER, matcher.group(4));
                                    }
                                }
                            }
                        }
                    }
                    if (h.get(StandardField.PAGES) == null) continue;
                    h.put(StandardField.PAGES, ((String)h.get(StandardField.PAGES)).replace("-", "--"));
                    continue;
                }
                if ("Abstract".equals(fieldName)) {
                    h.put(StandardField.ABSTRACT, content);
                    continue;
                }
                if ("Publication Type".equals(fieldName)) {
                    if (content.contains("Book")) {
                        h.put(InternalField.TYPE_HEADER, "book");
                        continue;
                    }
                    if (content.contains("Journal")) {
                        h.put(InternalField.TYPE_HEADER, "article");
                        continue;
                    }
                    if (!content.contains("Conference Paper")) continue;
                    h.put(InternalField.TYPE_HEADER, "inproceedings");
                    continue;
                }
                if (fieldName.startsWith("Language")) {
                    h.put(StandardField.LANGUAGE, content);
                    continue;
                }
                if (fieldName.startsWith("Author Keywords")) {
                    content = content.replace(";", ",").replace("  ", " ");
                    h.put(StandardField.KEYWORDS, content);
                    continue;
                }
                if (fieldName.startsWith("ISSN")) {
                    h.put(StandardField.ISSN, content);
                    continue;
                }
                if (!fieldName.startsWith("DOI Number")) continue;
                h.put(StandardField.DOI, content);
            }
            String auth = (String)h.get(StandardField.AUTHOR);
            if (auth != null && auth.contains(" [Ed]")) {
                h.remove(StandardField.AUTHOR);
                h.put(StandardField.EDITOR, auth.replace(" [Ed]", ""));
            }
            if ((auth = (String)h.get(StandardField.AUTHOR)) != null) {
                h.put(StandardField.AUTHOR, OvidImporter.fixNames(auth));
            }
            if ((auth = (String)h.get(StandardField.EDITOR)) != null) {
                h.put(StandardField.EDITOR, OvidImporter.fixNames(auth));
            }
            EntryType entryType = h.containsKey(InternalField.TYPE_HEADER) ? EntryTypeFactory.parse((String)h.get(InternalField.TYPE_HEADER)) : BibEntry.DEFAULT_TYPE;
            h.remove(InternalField.TYPE_HEADER);
            if (entryType.equals(StandardEntryType.Book) && h.containsKey(new UnknownField("chaptertitle"))) {
                entryType = StandardEntryType.InCollection;
                h.put(StandardField.TITLE, (String)h.remove(new UnknownField("chaptertitle")));
            }
            BibEntry b = new BibEntry(entryType);
            b.setField(h);
            bibitems.add(b);
        }
        return new ParserResult(bibitems);
    }

    private static String fixNames(String content) {
        String names;
        if (content.indexOf(59) > 0) {
            names = content.replaceAll("[^\\.A-Za-z,;\\- ]", "").replace(";", " and");
        } else if (content.indexOf("  ") > 0) {
            String[] sNames = content.split(" {2}");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < sNames.length; ++i) {
                if (i > 0) {
                    sb.append(" and ");
                }
                sb.append(sNames[i].replaceFirst(" ", ", "));
            }
            names = sb.toString();
        } else {
            names = content;
        }
        return AuthorList.fixAuthorLastNameFirst(names);
    }
}

