/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Date;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.entry.types.StandardEntryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepecNepImporter
extends Importer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepecNepImporter.class);
    private static final Collection<String> RECOGNIZED_FIELDS = Arrays.asList("Keywords", "JEL", "Date", "URL", "By");
    private final ImportFormatPreferences importFormatPreferences;
    private int line;
    private String lastLine = "";
    private String preLine = "";
    private boolean inOverviewSection;

    public RepecNepImporter(ImportFormatPreferences importFormatPreferences) {
        this.importFormatPreferences = importFormatPreferences;
    }

    @Override
    public String getName() {
        return "REPEC New Economic Papers (NEP)";
    }

    @Override
    public String getId() {
        return "repecnep";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.TXT;
    }

    @Override
    public String getDescription() {
        return "Imports a New Economics Papers-Message from the REPEC-NEP Service.";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        StringBuilder startOfMessage = new StringBuilder();
        String tmpLine = reader.readLine();
        for (int i = 0; i < 25 && tmpLine != null; ++i) {
            startOfMessage.append(tmpLine);
            tmpLine = reader.readLine();
        }
        return startOfMessage.toString().contains("NEP: New Economics Papers") || startOfMessage.toString().contains("nep.repec.org");
    }

    private boolean startsWithKeyword(Collection<String> keywords) {
        boolean result;
        boolean bl = result = this.lastLine.indexOf(58) >= 1;
        if (result) {
            String possibleKeyword = this.lastLine.substring(0, this.lastLine.indexOf(58));
            result = keywords.contains(possibleKeyword);
        }
        return result;
    }

    private void readLine(BufferedReader in) throws IOException {
        ++this.line;
        this.preLine = this.lastLine;
        this.lastLine = in.readLine();
    }

    private String readMultipleLines(BufferedReader in) throws IOException {
        StringBuilder result = new StringBuilder(this.lastLine.trim());
        this.readLine(in);
        while (!(this.lastLine == null || this.lastLine.trim().isEmpty() || this.startsWithKeyword(RECOGNIZED_FIELDS) || this.isStartOfWorkingPaper())) {
            result.append((String)(this.lastLine.isEmpty() ? this.lastLine.trim() : " " + this.lastLine.trim()));
            this.readLine(in);
        }
        return result.toString();
    }

    private void parseTitleString(BibEntry be, BufferedReader in) throws IOException {
        this.lastLine = this.lastLine.substring(this.lastLine.indexOf(46) + 1);
        be.setField(StandardField.TITLE, this.readMultipleLines(in));
    }

    private void parseAuthors(BibEntry be, BufferedReader in) throws IOException {
        ArrayList<String> authors = new ArrayList<String>();
        StringBuilder institutions = new StringBuilder();
        while (this.lastLine != null && !this.lastLine.isEmpty() && !this.startsWithKeyword(RECOGNIZED_FIELDS)) {
            boolean institutionDone;
            String author;
            StringBuilder institution = new StringBuilder();
            if (this.lastLine.indexOf(40) >= 0) {
                author = this.lastLine.substring(0, this.lastLine.indexOf(40)).trim();
                institutionDone = this.lastLine.indexOf(41) >= 1;
                institution.append(this.lastLine.substring(this.lastLine.indexOf(40) + 1, institutionDone && this.lastLine.indexOf(41) > this.lastLine.indexOf(40) + 1 ? this.lastLine.indexOf(41) : this.lastLine.length()).trim());
            } else {
                author = this.lastLine.trim();
                institutionDone = true;
            }
            this.readLine(in);
            while (!institutionDone && this.lastLine != null) {
                institutionDone = this.lastLine.indexOf(41) >= 1;
                institution.append(this.lastLine.substring(0, institutionDone ? this.lastLine.indexOf(41) : this.lastLine.length()).trim());
                this.readLine(in);
            }
            authors.add(author);
            if (institution.isEmpty()) continue;
            institutions.append((String)(institutions.isEmpty() ? institution.toString() : " and " + institution.toString()));
        }
        if (!authors.isEmpty()) {
            be.setField(StandardField.AUTHOR, String.join((CharSequence)" and ", authors));
        }
        if (!institutions.isEmpty()) {
            be.setField(StandardField.INSTITUTION, institutions.toString());
        }
    }

    private void parseAbstract(BibEntry be, BufferedReader in) throws IOException {
        String theabstract = this.readMultipleLines(in);
        if (!theabstract.isEmpty()) {
            be.setField(StandardField.ABSTRACT, theabstract);
        }
    }

    private void parseAdditionalFields(BibEntry be, boolean multilineUrlFieldAllowed, BufferedReader in) throws IOException {
        if (this.lastLine != null && this.lastLine.trim().isEmpty()) {
            this.readLine(in);
        }
        while (this.lastLine != null && !this.isStartOfWorkingPaper() && (this.startsWithKeyword(RECOGNIZED_FIELDS) || "".equals(this.lastLine))) {
            String content;
            String keyword = "".equals(this.lastLine) ? "" : this.lastLine.substring(0, this.lastLine.indexOf(58)).trim();
            String string = this.lastLine = "".equals(this.lastLine) ? "" : this.lastLine.substring(this.lastLine.indexOf(58) + 1).trim();
            if ("Keywords".equals(keyword)) {
                content = this.readMultipleLines(in);
                String[] keywords = content.split("[,;]");
                be.addKeywords(Arrays.asList(keywords), this.importFormatPreferences.bibEntryPreferences().getKeywordSeparator());
                continue;
            }
            if ("JEL".equals(keyword)) {
                be.setField(new UnknownField("jel"), this.readMultipleLines(in));
                continue;
            }
            if (keyword.startsWith("Date")) {
                content = this.readMultipleLines(in);
                Date.parse(content).ifPresent(be::setDate);
                continue;
            }
            if (keyword.startsWith("URL")) {
                if (multilineUrlFieldAllowed) {
                    content = this.readMultipleLines(in);
                } else {
                    content = this.lastLine;
                    this.readLine(in);
                }
                be.setField(StandardField.URL, content);
                continue;
            }
            if (keyword.startsWith("By")) {
                this.parseAuthors(be, in);
                continue;
            }
            this.readLine(in);
        }
    }

    private boolean isStartOfWorkingPaper() {
        return this.lastLine.matches("\\d+\\.\\s.*") && !this.inOverviewSection && this.preLine.trim().isEmpty();
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        Objects.requireNonNull(reader);
        ArrayList<BibEntry> bibitems = new ArrayList<BibEntry>();
        String paperNoStr = null;
        this.line = 0;
        try {
            this.readLine(reader);
            while (this.lastLine != null) {
                if (this.lastLine.startsWith("-----------------------------")) {
                    this.inOverviewSection = this.preLine.startsWith("In this issue we have");
                }
                if (this.isStartOfWorkingPaper()) {
                    BibEntry be = new BibEntry(StandardEntryType.TechReport);
                    paperNoStr = this.lastLine.substring(0, this.lastLine.indexOf(46));
                    this.parseTitleString(be, reader);
                    if (this.startsWithKeyword(RECOGNIZED_FIELDS)) {
                        this.parseAdditionalFields(be, false, reader);
                    } else {
                        this.readLine(reader);
                        this.parseAuthors(be, reader);
                        this.readLine(reader);
                    }
                    if (!this.startsWithKeyword(RECOGNIZED_FIELDS)) {
                        this.parseAbstract(be, reader);
                    }
                    this.parseAdditionalFields(be, true, reader);
                    bibitems.add(be);
                    paperNoStr = null;
                    continue;
                }
                this.preLine = this.lastLine;
                this.readLine(reader);
            }
        }
        catch (Exception e) {
            String message = "Error in REPEC-NEP import on line " + this.line;
            if (paperNoStr != null) {
                message = message + ", paper no. " + paperNoStr + ": ";
            }
            message = message + e.getLocalizedMessage();
            LOGGER.error(message, (Throwable)e);
            return ParserResult.fromErrorMessage(message);
        }
        return new ParserResult(bibitems);
    }
}

