/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.fetcher.GrobidPreferences;
import org.jabref.logic.importer.fileformat.BibtexParser;
import org.jabref.model.entry.BibEntry;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class GrobidService {
    private final GrobidPreferences grobidPreferences;

    public GrobidService(GrobidPreferences grobidPreferences) {
        this.grobidPreferences = grobidPreferences;
        if (!grobidPreferences.isGrobidEnabled()) {
            throw new UnsupportedOperationException("Grobid was used but not enabled.");
        }
    }

    public Optional<BibEntry> processCitation(String rawCitation, ImportFormatPreferences importFormatPreferences, ConsolidateCitations consolidateCitations) throws IOException, ParseException {
        Connection.Response response = Jsoup.connect((String)(this.grobidPreferences.getGrobidURL() + "/api/processCitation")).header("Accept", "application/x-bibtex").data("citations", rawCitation).data("consolidateCitations", String.valueOf(consolidateCitations.getCode())).method(Connection.Method.POST).ignoreContentType(true).timeout(100000).execute();
        String httpResponse = response.body();
        if (httpResponse == null || "@misc{-1,\n  author = {}\n}\n".equals(httpResponse) || httpResponse.equals("@misc{-1,\n  author = {" + rawCitation + "}\n}\n")) {
            throw new IOException("The GROBID server response does not contain anything.");
        }
        return BibtexParser.singleFromString(httpResponse, importFormatPreferences);
    }

    public List<BibEntry> processPDF(Path filePath, ImportFormatPreferences importFormatPreferences) throws IOException, ParseException {
        Connection.Response response = Jsoup.connect((String)(this.grobidPreferences.getGrobidURL() + "/api/processHeaderDocument")).header("Accept", "application/x-bibtex").data("input", filePath.toString(), Files.newInputStream(filePath, new OpenOption[0])).method(Connection.Method.POST).ignoreContentType(true).timeout(20000).execute();
        String httpResponse = response.body();
        return GrobidService.getBibEntries(importFormatPreferences, httpResponse);
    }

    public List<BibEntry> processReferences(List<Path> pathList, ImportFormatPreferences importFormatPreferences) throws IOException, ParseException {
        ArrayList<BibEntry> entries = new ArrayList<BibEntry>();
        for (Path filePath : pathList) {
            entries.addAll(this.processReferences(filePath, importFormatPreferences));
        }
        return entries;
    }

    public List<BibEntry> processReferences(Path filePath, ImportFormatPreferences importFormatPreferences) throws IOException, ParseException {
        Connection.Response response = Jsoup.connect((String)(this.grobidPreferences.getGrobidURL() + "/api/processReferences")).header("Accept", "application/x-bibtex").data("input", filePath.toString(), Files.newInputStream(filePath, new OpenOption[0])).data("consolidateCitations", String.valueOf((Object)ConsolidateCitations.WITH_METADATA)).method(Connection.Method.POST).ignoreContentType(true).timeout(20000).execute();
        String httpResponse = response.body();
        return GrobidService.getBibEntries(importFormatPreferences, httpResponse);
    }

    private static List<BibEntry> getBibEntries(ImportFormatPreferences importFormatPreferences, String httpResponse) throws IOException, ParseException {
        if (httpResponse == null || "@misc{-1,\n  author = {}\n}\n".equals(httpResponse)) {
            throw new IOException("The GROBID server response does not contain anything.");
        }
        BibtexParser parser = new BibtexParser(importFormatPreferences);
        List<BibEntry> result = parser.parseEntries(httpResponse);
        result.forEach(entry -> entry.setCitationKey(""));
        return result;
    }

    public static enum ConsolidateCitations {
        NO(0),
        WITH_METADATA(1),
        WITH_DOI_ONLY(2);

        private final int code;

        private ConsolidateCitations(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

