/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import kong.unirest.core.json.JSONArray;
import kong.unirest.core.json.JSONException;
import kong.unirest.core.json.JSONObject;
import org.jabref.logic.importer.ParseException;

public class JsonReader {
    public static JSONObject toJsonObject(InputStream inputStream) throws ParseException {
        try {
            String inputStr = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            if (inputStr.isBlank()) {
                return new JSONObject();
            }
            return new JSONObject(inputStr);
        }
        catch (IOException | JSONException e) {
            throw new ParseException(e);
        }
    }

    public static JSONArray toJsonArray(InputStream stream) throws ParseException {
        try {
            String inpStr = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
            if (inpStr.isBlank()) {
                return new JSONArray();
            }
            return new JSONArray(inpStr);
        }
        catch (IOException | JSONException e) {
            throw new ParseException(e);
        }
    }
}

