/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import kong.unirest.core.json.JSONException;
import kong.unirest.core.json.JSONObject;
import org.apache.hc.core5.net.URIBuilder;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.util.JsonReader;
import org.jabref.logic.importer.util.ShortDOIServiceException;
import org.jabref.logic.net.URLDownload;
import org.jabref.model.entry.identifier.DOI;

public class ShortDOIService {
    private static final String BASIC_URL = "http://shortdoi.org/";

    public DOI getShortDOI(DOI doi) throws ShortDOIServiceException {
        JSONObject responseJSON = this.makeRequest(doi);
        String shortDoi = responseJSON.getString("ShortDOI");
        return new DOI(shortDoi);
    }

    private JSONObject makeRequest(DOI doi) throws ShortDOIServiceException {
        URIBuilder uriBuilder = null;
        URL url = null;
        try {
            uriBuilder = new URIBuilder(BASIC_URL);
            uriBuilder.setPath(uriBuilder.getPath() + doi.getDOI());
            uriBuilder.addParameter("format", "json");
            URI uri = uriBuilder.build();
            url = uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new ShortDOIServiceException("Cannot get short DOI", e);
        }
        URLDownload urlDownload = new URLDownload(url);
        try {
            JSONObject resultAsJSON = JsonReader.toJsonObject(urlDownload.asInputStream());
            if (resultAsJSON.isEmpty()) {
                throw new ShortDOIServiceException("Cannot get short DOI");
            }
            return resultAsJSON;
        }
        catch (IOException | JSONException | ParseException e) {
            throw new ShortDOIServiceException("Cannot get short DOI", e);
        }
    }
}

