/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jabref.logic.integrity.EntryChecker;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;

public class AbbreviationChecker
implements EntryChecker {
    private final JournalAbbreviationRepository abbreviationRepository;
    private final Set<Field> fields = FieldFactory.getBookNameFields();

    public AbbreviationChecker(JournalAbbreviationRepository abbreviationRepository) {
        this.abbreviationRepository = abbreviationRepository;
    }

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        ArrayList<IntegrityMessage> messages = new ArrayList<IntegrityMessage>();
        for (Field field : this.fields) {
            Optional<String> value = entry.getFieldLatexFree(field);
            value.filter(this.abbreviationRepository::isAbbreviatedName).ifPresent(val -> messages.add(new IntegrityMessage(Localization.lang("abbreviation detected", new Object[0]), entry, field)));
        }
        return messages;
    }
}

