/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import com.google.common.base.CharMatcher;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javafx.util.Pair;
import org.jabref.logic.integrity.EntryChecker;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;

public class AmpersandChecker
implements EntryChecker {
    private static final Pattern BACKSLASH_PRECEDED_AMPERSAND = Pattern.compile("\\\\*&");

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        return entry.getFieldMap().entrySet().stream().filter(field -> FieldFactory.isLatexField((Field)field.getKey())).flatMap(AmpersandChecker::getUnescapedAmpersandsWithCount).map(pair -> new IntegrityMessage(Localization.lang("Found %0 unescaped '&'", pair.getValue()), entry, (Field)pair.getKey())).toList();
    }

    private static Stream<Pair<Field, Long>> getUnescapedAmpersandsWithCount(Map.Entry<Field, String> entry) {
        long unescapedAmpersands = BACKSLASH_PRECEDED_AMPERSAND.matcher(entry.getValue()).results().map(MatchResult::group).filter(m -> CharMatcher.is((char)'\\').countIn((CharSequence)m) % 2 == 0).count();
        if (unescapedAmpersands == 0L) {
            return Stream.empty();
        }
        return Stream.of(new Pair((Object)entry.getKey(), (Object)unescapedAmpersands));
    }
}

