/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jabref.logic.integrity.ValueChecker;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.strings.StringUtil;

public class EditionChecker
implements ValueChecker {
    private static final Predicate<String> FIRST_LETTER_CAPITALIZED = Pattern.compile("^[A-Z]").asPredicate();
    private static final Predicate<String> ONLY_NUMERALS_OR_LITERALS = Pattern.compile("^([0-9]+|[^0-9].+)$").asPredicate();
    private static final Predicate<String> ONLY_NUMERALS = Pattern.compile("[0-9]+").asPredicate();
    private static final String FIRST_EDITION = "1";
    private final BibDatabaseContext bibDatabaseContextEdition;
    private final boolean allowIntegerEdition;

    public EditionChecker(BibDatabaseContext bibDatabaseContext, boolean allowIntegerEdition) {
        this.bibDatabaseContextEdition = Objects.requireNonNull(bibDatabaseContext);
        this.allowIntegerEdition = allowIntegerEdition;
    }

    @Override
    public Optional<String> checkValue(String value) {
        if (StringUtil.isBlank(value)) {
            return Optional.empty();
        }
        if (value.equals(FIRST_EDITION)) {
            return Optional.of(Localization.lang("edition of book reported as just 1", new Object[0]));
        }
        if (this.bibDatabaseContextEdition.isBiblatexMode()) {
            if (!ONLY_NUMERALS_OR_LITERALS.test(value.trim())) {
                return Optional.of(Localization.lang("should contain an integer or a literal", new Object[0]));
            }
        } else if (ONLY_NUMERALS.test(value) && !this.allowIntegerEdition) {
            return Optional.of(Localization.lang("no integer as values for edition allowed", new Object[0]));
        }
        if (!this.isFirstCharDigit(value) && !FIRST_LETTER_CAPITALIZED.test(value.trim())) {
            return Optional.of(Localization.lang("should have the first letter capitalized", new Object[0]));
        }
        return Optional.empty();
    }

    boolean isFirstCharDigit(String input) {
        return !StringUtil.isNullOrEmpty(input) && Character.isDigit(input.charAt(0));
    }
}

