/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.List;
import java.util.regex.Pattern;
import org.jabref.logic.integrity.EntryChecker;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldProperty;

public class HTMLCharacterChecker
implements EntryChecker {
    private static final Pattern HTML_CHARACTER_PATTERN = Pattern.compile("&[#\\p{Alnum}]+;");

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        return entry.getFieldMap().entrySet().stream().filter(field -> !((Field)field.getKey()).getProperties().contains((Object)FieldProperty.VERBATIM)).filter(field -> HTML_CHARACTER_PATTERN.matcher((CharSequence)field.getValue()).find()).map(field -> new IntegrityMessage(Localization.lang("HTML encoded character found", new Object[0]), entry, (Field)field.getKey())).toList();
    }
}

