/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jabref.logic.citationkeypattern.CitationKeyPatternPreferences;
import org.jabref.logic.integrity.ASCIICharacterChecker;
import org.jabref.logic.integrity.AmpersandChecker;
import org.jabref.logic.integrity.BibStringChecker;
import org.jabref.logic.integrity.BibTeXEntryTypeChecker;
import org.jabref.logic.integrity.CitationKeyChecker;
import org.jabref.logic.integrity.CitationKeyDeviationChecker;
import org.jabref.logic.integrity.CitationKeyDuplicationChecker;
import org.jabref.logic.integrity.DoiDuplicationChecker;
import org.jabref.logic.integrity.EntryChecker;
import org.jabref.logic.integrity.EntryLinkChecker;
import org.jabref.logic.integrity.FieldChecker;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.integrity.HTMLCharacterChecker;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.integrity.JournalInAbbreviationListChecker;
import org.jabref.logic.integrity.LatexIntegrityChecker;
import org.jabref.logic.integrity.NoBibtexFieldChecker;
import org.jabref.logic.integrity.TypeChecker;
import org.jabref.logic.integrity.UTF8Checker;
import org.jabref.logic.integrity.UnicodeNormalFormCanonicalCompositionCheck;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.FilePreferences;

public class IntegrityCheck {
    private final BibDatabaseContext bibDatabaseContext;
    private final FieldCheckers fieldCheckers;
    private final List<EntryChecker> entryCheckers;

    public IntegrityCheck(BibDatabaseContext bibDatabaseContext, FilePreferences filePreferences, CitationKeyPatternPreferences citationKeyPatternPreferences, JournalAbbreviationRepository journalAbbreviationRepository, boolean allowIntegerEdition) {
        this.bibDatabaseContext = bibDatabaseContext;
        this.fieldCheckers = new FieldCheckers(bibDatabaseContext, filePreferences, journalAbbreviationRepository, allowIntegerEdition);
        this.entryCheckers = new ArrayList<JournalInAbbreviationListChecker>(List.of(new CitationKeyChecker(), new TypeChecker(), new BibStringChecker(), new HTMLCharacterChecker(), new EntryLinkChecker(bibDatabaseContext.getDatabase()), new CitationKeyDeviationChecker(bibDatabaseContext, citationKeyPatternPreferences), new CitationKeyDuplicationChecker(bibDatabaseContext.getDatabase()), new AmpersandChecker(), new LatexIntegrityChecker(), new JournalInAbbreviationListChecker(StandardField.JOURNAL, journalAbbreviationRepository)));
        if (bibDatabaseContext.isBiblatexMode()) {
            this.entryCheckers.add(new UTF8Checker(bibDatabaseContext.getMetaData().getEncoding().orElse(StandardCharsets.UTF_8)));
        } else {
            this.entryCheckers.addAll(List.of(new ASCIICharacterChecker(), new NoBibtexFieldChecker(), new UnicodeNormalFormCanonicalCompositionCheck(), new BibTeXEntryTypeChecker()));
        }
    }

    List<IntegrityMessage> check() {
        ArrayList<IntegrityMessage> result = new ArrayList<IntegrityMessage>();
        BibDatabase database = this.bibDatabaseContext.getDatabase();
        for (BibEntry entry : database.getEntries()) {
            result.addAll(this.checkEntry(entry));
        }
        result.addAll(this.checkDatabase(database));
        return result;
    }

    public List<IntegrityMessage> checkEntry(BibEntry entry) {
        ArrayList<IntegrityMessage> result = new ArrayList<IntegrityMessage>();
        if (entry == null) {
            return result;
        }
        for (FieldChecker fieldChecker : this.fieldCheckers.getAll()) {
            result.addAll(fieldChecker.check(entry));
        }
        for (EntryChecker entryChecker : this.entryCheckers) {
            result.addAll(entryChecker.check(entry));
        }
        return result;
    }

    public List<IntegrityMessage> checkDatabase(BibDatabase database) {
        return new DoiDuplicationChecker().check(database);
    }
}

