/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Objects;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;

public final class IntegrityMessage
implements Cloneable {
    private final BibEntry entry;
    private final Field field;
    private final String message;

    public IntegrityMessage(String message, BibEntry entry, Field field) {
        this.message = message;
        this.entry = entry;
        this.field = field;
    }

    public String toString() {
        return "[" + this.getEntry().getCitationKey().orElse("") + "] in " + this.field.getDisplayName() + ": " + this.getMessage();
    }

    public String getMessage() {
        return this.message;
    }

    public BibEntry getEntry() {
        return this.entry;
    }

    public Field getField() {
        return this.field;
    }

    public Object clone() {
        return new IntegrityMessage(this.message, this.entry, this.field);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrityMessage that = (IntegrityMessage)o;
        return Objects.equals(this.entry, that.entry) && Objects.equals(this.field, that.field) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.entry, this.field, this.message);
    }
}

