/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Optional;
import org.jabref.logic.citationkeypattern.CitationKeyGenerator;
import org.jabref.logic.integrity.ValueChecker;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.strings.StringUtil;

public class ValidCitationKeyChecker
implements ValueChecker {
    @Override
    public Optional<String> checkValue(String value) {
        if (StringUtil.isNullOrEmpty(value)) {
            return Optional.of(Localization.lang("empty citation key", new Object[0]));
        }
        String cleaned = CitationKeyGenerator.cleanKey(value, "");
        if (cleaned.equals(value)) {
            return Optional.empty();
        }
        return Optional.of(Localization.lang("Invalid citation key", new Object[0]));
    }
}

