/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.journals;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import javafx.collections.ObservableList;
import org.jabref.logic.journals.Abbreviation;
import org.jabref.logic.journals.AbbreviationParser;
import org.jabref.logic.journals.JournalAbbreviationPreferences;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalAbbreviationLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JournalAbbreviationLoader.class);

    public static Collection<Abbreviation> readAbbreviationsFromCsvFile(Path file) throws IOException {
        LOGGER.debug("Reading journal list from file {}", (Object)file);
        AbbreviationParser parser = new AbbreviationParser();
        parser.readJournalListFromFile(file);
        return parser.getAbbreviations();
    }

    public static JournalAbbreviationRepository loadRepository(JournalAbbreviationPreferences journalAbbreviationPreferences) {
        JournalAbbreviationRepository repository;
        try (InputStream resourceAsStream = JournalAbbreviationRepository.class.getResourceAsStream("/journals/journal-list.mv");){
            if (resourceAsStream == null) {
                LOGGER.warn("There is no journal-list.mv. We use a default journal list");
                repository = new JournalAbbreviationRepository();
            } else {
                Path tempDir = Files.createTempDirectory("jabref-journal", new FileAttribute[0]);
                Path tempJournalList = tempDir.resolve("journal-list.mv");
                Files.copy(resourceAsStream, tempJournalList, new CopyOption[0]);
                repository = new JournalAbbreviationRepository(tempJournalList);
                tempDir.toFile().deleteOnExit();
                tempJournalList.toFile().deleteOnExit();
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while copying journal list", (Throwable)e);
            return null;
        }
        ObservableList<String> lists = journalAbbreviationPreferences.getExternalJournalLists();
        if (lists != null && !lists.isEmpty()) {
            Collections.reverse(lists);
            for (String filename : lists) {
                try {
                    repository.addCustomAbbreviations(JournalAbbreviationLoader.readAbbreviationsFromCsvFile(Path.of(filename, new String[0])));
                }
                catch (IOException e) {
                    LOGGER.error("Cannot read external journal list file {}", (Object)filename, (Object)e);
                }
            }
        }
        return repository;
    }

    public static JournalAbbreviationRepository loadBuiltInRepository() {
        return JournalAbbreviationLoader.loadRepository(new JournalAbbreviationPreferences(Collections.emptyList(), true));
    }
}

