/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.layout.LayoutEntry;
import org.jabref.logic.layout.LayoutFormatter;
import org.jabref.logic.layout.LayoutFormatterPreferences;
import org.jabref.logic.layout.StringInt;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Layout {
    private static final Logger LOGGER = LoggerFactory.getLogger(Layout.class);
    private final List<LayoutEntry> layoutEntries;
    private final List<String> missingFormatters = new ArrayList<String>();

    public Layout(List<StringInt> parsedEntries, List<Path> fileDirForDatabase, LayoutFormatterPreferences layoutPreferences, JournalAbbreviationRepository abbreviationRepository) {
        ArrayList<LayoutEntry> tmpEntries = new ArrayList<LayoutEntry>(parsedEntries.size());
        ArrayList<StringInt> blockEntries = null;
        String blockStart = null;
        for (StringInt parsedEntry : parsedEntries) {
            switch (parsedEntry.i) {
                case 1: 
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 6: {
                    blockEntries = new ArrayList<StringInt>();
                    blockStart = parsedEntry.s;
                    break;
                }
                case 4: 
                case 7: {
                    if (blockStart == null || blockEntries == null) break;
                    if (blockStart.equals(parsedEntry.s)) {
                        blockEntries.add(parsedEntry);
                        LayoutEntry le = new LayoutEntry(blockEntries, parsedEntry.i == 4 ? 3 : 6, fileDirForDatabase, layoutPreferences, abbreviationRepository);
                        tmpEntries.add(le);
                        blockEntries = null;
                        break;
                    }
                    LOGGER.debug(blockStart + "\n" + parsedEntry.s);
                    LOGGER.warn("Nested field/group entries are not implemented!");
                    Thread.dumpStack();
                    break;
                }
            }
            if (blockEntries == null) {
                tmpEntries.add(new LayoutEntry(parsedEntry, fileDirForDatabase, layoutPreferences, abbreviationRepository));
                continue;
            }
            blockEntries.add(parsedEntry);
        }
        this.layoutEntries = new ArrayList<LayoutEntry>(tmpEntries);
        for (LayoutEntry layoutEntry : this.layoutEntries) {
            this.missingFormatters.addAll(layoutEntry.getInvalidFormatters());
        }
    }

    public void setPostFormatter(LayoutFormatter formatter) {
        for (LayoutEntry layoutEntry : this.layoutEntries) {
            layoutEntry.setPostFormatter(formatter);
        }
    }

    public String getText() {
        return this.layoutEntries.stream().map(LayoutEntry::getText).collect(Collectors.joining("\n"));
    }

    public String doLayout(BibEntry bibtex, BibDatabase database) {
        StringBuilder builder = new StringBuilder(100);
        for (LayoutEntry layoutEntry : this.layoutEntries) {
            String fieldText = layoutEntry.doLayout(bibtex, database);
            if (fieldText == null) {
                fieldText = "";
            }
            builder.append(fieldText);
        }
        return builder.toString();
    }

    public String doLayout(BibDatabaseContext databaseContext, Charset encoding) {
        StringBuilder sb = new StringBuilder(100);
        for (LayoutEntry layoutEntry : this.layoutEntries) {
            String fieldText = layoutEntry.doLayout(databaseContext, encoding);
            if (fieldText == null) {
                fieldText = "";
            }
            sb.append(fieldText);
        }
        return sb.toString();
    }

    public List<String> getMissingFormatters() {
        return new ArrayList<String>(this.missingFormatters);
    }
}

