/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jabref.logic.formatter.bibtexfields.HtmlToLatexFormatter;
import org.jabref.logic.formatter.bibtexfields.UnicodeToLatexFormatter;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.layout.LayoutFormatter;
import org.jabref.logic.layout.LayoutFormatterPreferences;
import org.jabref.logic.layout.LayoutHelper;
import org.jabref.logic.layout.ParamLayoutFormatter;
import org.jabref.logic.layout.StringInt;
import org.jabref.logic.layout.format.AuthorAbbreviator;
import org.jabref.logic.layout.format.AuthorAndToSemicolonReplacer;
import org.jabref.logic.layout.format.AuthorAndsCommaReplacer;
import org.jabref.logic.layout.format.AuthorAndsReplacer;
import org.jabref.logic.layout.format.AuthorFirstAbbrLastCommas;
import org.jabref.logic.layout.format.AuthorFirstAbbrLastOxfordCommas;
import org.jabref.logic.layout.format.AuthorFirstFirst;
import org.jabref.logic.layout.format.AuthorFirstFirstCommas;
import org.jabref.logic.layout.format.AuthorFirstLastCommas;
import org.jabref.logic.layout.format.AuthorFirstLastOxfordCommas;
import org.jabref.logic.layout.format.AuthorLF_FF;
import org.jabref.logic.layout.format.AuthorLF_FFAbbr;
import org.jabref.logic.layout.format.AuthorLastFirst;
import org.jabref.logic.layout.format.AuthorLastFirstAbbrCommas;
import org.jabref.logic.layout.format.AuthorLastFirstAbbrOxfordCommas;
import org.jabref.logic.layout.format.AuthorLastFirstAbbreviator;
import org.jabref.logic.layout.format.AuthorLastFirstCommas;
import org.jabref.logic.layout.format.AuthorLastFirstOxfordCommas;
import org.jabref.logic.layout.format.AuthorNatBib;
import org.jabref.logic.layout.format.AuthorOrgSci;
import org.jabref.logic.layout.format.Authors;
import org.jabref.logic.layout.format.CSLType;
import org.jabref.logic.layout.format.CompositeFormat;
import org.jabref.logic.layout.format.CreateBibORDFAuthors;
import org.jabref.logic.layout.format.CreateDocBook4Authors;
import org.jabref.logic.layout.format.CreateDocBook4Editors;
import org.jabref.logic.layout.format.CreateDocBook5Authors;
import org.jabref.logic.layout.format.CreateDocBook5Editors;
import org.jabref.logic.layout.format.CurrentDate;
import org.jabref.logic.layout.format.DOICheck;
import org.jabref.logic.layout.format.DOIStrip;
import org.jabref.logic.layout.format.DateFormatter;
import org.jabref.logic.layout.format.Default;
import org.jabref.logic.layout.format.EntryTypeFormatter;
import org.jabref.logic.layout.format.FileLink;
import org.jabref.logic.layout.format.FirstPage;
import org.jabref.logic.layout.format.FormatPagesForHTML;
import org.jabref.logic.layout.format.FormatPagesForXML;
import org.jabref.logic.layout.format.GetOpenOfficeType;
import org.jabref.logic.layout.format.HTMLChars;
import org.jabref.logic.layout.format.HTMLParagraphs;
import org.jabref.logic.layout.format.HayagrivaType;
import org.jabref.logic.layout.format.IfPlural;
import org.jabref.logic.layout.format.Iso690FormatDate;
import org.jabref.logic.layout.format.Iso690NamesAuthors;
import org.jabref.logic.layout.format.JournalAbbreviator;
import org.jabref.logic.layout.format.LastPage;
import org.jabref.logic.layout.format.LatexToUnicodeFormatter;
import org.jabref.logic.layout.format.MarkdownFormatter;
import org.jabref.logic.layout.format.NameFormatter;
import org.jabref.logic.layout.format.NoSpaceBetweenAbbreviations;
import org.jabref.logic.layout.format.NotFoundFormatter;
import org.jabref.logic.layout.format.Number;
import org.jabref.logic.layout.format.Ordinal;
import org.jabref.logic.layout.format.RTFChars;
import org.jabref.logic.layout.format.RemoveBrackets;
import org.jabref.logic.layout.format.RemoveBracketsAddComma;
import org.jabref.logic.layout.format.RemoveLatexCommandsFormatter;
import org.jabref.logic.layout.format.RemoveTilde;
import org.jabref.logic.layout.format.RemoveWhitespace;
import org.jabref.logic.layout.format.Replace;
import org.jabref.logic.layout.format.ReplaceWithEscapedDoubleQuotes;
import org.jabref.logic.layout.format.RisAuthors;
import org.jabref.logic.layout.format.RisKeywords;
import org.jabref.logic.layout.format.RisMonth;
import org.jabref.logic.layout.format.ShortMonthFormatter;
import org.jabref.logic.layout.format.ToLowerCase;
import org.jabref.logic.layout.format.ToUpperCase;
import org.jabref.logic.layout.format.WrapContent;
import org.jabref.logic.layout.format.WrapFileLinks;
import org.jabref.logic.layout.format.XMLChars;
import org.jabref.logic.openoffice.style.OOPreFormatter;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LayoutEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(LayoutEntry.class);
    private List<LayoutFormatter> option;
    private LayoutFormatter postFormatter;
    private String text;
    private List<LayoutEntry> layoutEntries;
    private final int type;
    private final List<String> invalidFormatter = new ArrayList<String>();
    private final List<Path> fileDirForDatabase;
    private final LayoutFormatterPreferences preferences;
    private final JournalAbbreviationRepository abbreviationRepository;

    public LayoutEntry(StringInt si, List<Path> fileDirForDatabase, LayoutFormatterPreferences preferences, JournalAbbreviationRepository abbreviationRepository) {
        this.preferences = preferences;
        this.abbreviationRepository = abbreviationRepository;
        this.fileDirForDatabase = Objects.requireNonNullElse(fileDirForDatabase, Collections.emptyList());
        this.type = si.i;
        switch (this.type) {
            case 1: {
                this.text = si.s;
                break;
            }
            case 2: {
                this.text = si.s.trim();
                break;
            }
            case 5: {
                this.doOptionField(si.s);
                break;
            }
        }
    }

    public LayoutEntry(List<StringInt> parsedEntries, int layoutType, List<Path> fileDirForDatabase, LayoutFormatterPreferences preferences, JournalAbbreviationRepository abbreviationRepository) {
        this.preferences = preferences;
        this.abbreviationRepository = abbreviationRepository;
        this.fileDirForDatabase = Objects.requireNonNullElse(fileDirForDatabase, Collections.emptyList());
        ArrayList<LayoutEntry> tmpEntries = new ArrayList<LayoutEntry>();
        String blockStart = parsedEntries.getFirst().s;
        String blockEnd = parsedEntries.getLast().s;
        if (!blockStart.equals(blockEnd)) {
            LOGGER.warn("Field start and end entry must be equal.");
        }
        this.type = layoutType;
        this.text = blockEnd;
        ArrayList<StringInt> blockEntries = null;
        for (StringInt parsedEntry : parsedEntries.subList(1, parsedEntries.size() - 1)) {
            switch (parsedEntry.i) {
                case 3: 
                case 6: {
                    blockEntries = new ArrayList<StringInt>();
                    blockStart = parsedEntry.s;
                    break;
                }
                case 4: 
                case 7: {
                    if (blockStart.equals(parsedEntry.s)) {
                        blockEntries.add(parsedEntry);
                        int groupType = parsedEntry.i == 7 ? 6 : 3;
                        LayoutEntry le = new LayoutEntry(blockEntries, groupType, fileDirForDatabase, preferences, abbreviationRepository);
                        tmpEntries.add(le);
                        blockEntries = null;
                        break;
                    }
                    LOGGER.warn("Nested field entries are not implemented!");
                    break;
                }
            }
            if (blockEntries == null) {
                tmpEntries.add(new LayoutEntry(parsedEntry, fileDirForDatabase, preferences, abbreviationRepository));
                continue;
            }
            blockEntries.add(parsedEntry);
        }
        this.layoutEntries = new ArrayList<LayoutEntry>(tmpEntries);
        for (LayoutEntry layoutEntry : this.layoutEntries) {
            this.invalidFormatter.addAll(layoutEntry.getInvalidFormatters());
        }
    }

    public void setPostFormatter(LayoutFormatter formatter) {
        this.postFormatter = formatter;
    }

    public String doLayout(BibEntry bibtex, BibDatabase database) {
        switch (this.type) {
            case 1: {
                return this.text;
            }
            case 2: {
                String value = bibtex.getResolvedFieldOrAlias(FieldFactory.parseField(this.text), database).orElse("");
                if (this.postFormatter != null) {
                    value = this.postFormatter.format(value);
                }
                return value;
            }
            case 3: 
            case 6: {
                return this.handleFieldOrGroupStart(bibtex, database);
            }
            case 4: 
            case 7: {
                return "";
            }
            case 5: {
                return this.handleOptionField(bibtex, database);
            }
            case 8: {
                return bibtex.getResolvedFieldOrAlias(new UnknownField("encoding"), database).orElse(null);
            }
        }
        return "";
    }

    private String handleOptionField(BibEntry bibtex, BibDatabase database) {
        String fieldEntry;
        if (InternalField.TYPE_HEADER.getName().equals(this.text)) {
            fieldEntry = bibtex.getType().getDisplayName();
        } else if (InternalField.OBSOLETE_TYPE_HEADER.getName().equals(this.text)) {
            LOGGER.warn("'" + String.valueOf(InternalField.OBSOLETE_TYPE_HEADER) + "' is an obsolete name for the entry type. Please update your layout to use '" + String.valueOf(InternalField.TYPE_HEADER) + "' instead.");
            fieldEntry = bibtex.getType().getDisplayName();
        } else {
            String string = fieldEntry = this.text.startsWith("\\") ? bibtex.getResolvedFieldOrAlias(FieldFactory.parseField(this.text.substring(1)), database).orElse("") : BibDatabase.getText(this.text, database);
        }
        if (this.option != null) {
            for (LayoutFormatter anOption : this.option) {
                fieldEntry = anOption.format(fieldEntry);
            }
        }
        if (this.postFormatter != null) {
            fieldEntry = this.postFormatter.format(fieldEntry);
        }
        return fieldEntry;
    }

    private String handleFieldOrGroupStart(BibEntry bibtex, BibDatabase database) {
        Optional<String> field;
        boolean negated = false;
        if (this.type == 6) {
            field = bibtex.getResolvedFieldOrAlias(FieldFactory.parseField(this.text), database);
        } else if (this.text.matches(".*(;|(\\&+)).*")) {
            parts = this.text.split("\\s*(;|(\\&+))\\s*");
            field = Optional.empty();
            var6_6 = parts;
            var7_7 = var6_6.length;
            for (var8_8 = 0; var8_8 < var7_7 && (field = bibtex.getResolvedFieldOrAlias(FieldFactory.parseField((negated = (part = var6_6[var8_8]).startsWith("!")) ? part.substring(1).trim() : part), database)).isPresent() != negated; ++var8_8) {
            }
        } else {
            parts = this.text.split("\\s*(\\|+)\\s*");
            field = Optional.empty();
            var6_6 = parts;
            var7_7 = var6_6.length;
            for (var8_8 = 0; var8_8 < var7_7 && !((field = bibtex.getResolvedFieldOrAlias(FieldFactory.parseField((negated = (part = var6_6[var8_8]).startsWith("!")) ? part.substring(1).trim() : part), database)).isPresent() ^ negated); ++var8_8) {
            }
        }
        if (field.isPresent() == negated || this.type == 6 && field.get().equalsIgnoreCase(LayoutHelper.getCurrentGroup())) {
            return null;
        }
        if (this.type == 6) {
            LayoutHelper.setCurrentGroup(field.get());
        }
        StringBuilder sb = new StringBuilder(100);
        boolean previousSkipped = false;
        for (int i = 0; i < this.layoutEntries.size(); ++i) {
            String fieldText = this.layoutEntries.get(i).doLayout(bibtex, database);
            if (fieldText == null) {
                if (i + 1 < this.layoutEntries.size() && this.layoutEntries.get(i + 1).doLayout(bibtex, database).trim().isEmpty()) {
                    ++i;
                    previousSkipped = true;
                    continue;
                }
            } else if (previousSkipped) {
                int eol;
                for (eol = 0; eol < fieldText.length() && (fieldText.charAt(eol) == '\n' || fieldText.charAt(eol) == '\r'); ++eol) {
                }
                if (eol < fieldText.length()) {
                    sb.append(fieldText.substring(eol));
                }
            } else {
                sb.append(fieldText);
            }
            previousSkipped = false;
        }
        return sb.toString();
    }

    public String doLayout(BibDatabaseContext databaseContext, Charset encoding) {
        switch (this.type) {
            case 1: {
                return this.text;
            }
            case 2: {
                throw new UnsupportedOperationException("bibtex entry fields not allowed in begin or end layout");
            }
            case 3: 
            case 6: {
                throw new UnsupportedOperationException("field and group starts not allowed in begin or end layout");
            }
            case 4: 
            case 7: {
                throw new UnsupportedOperationException("field and group ends not allowed in begin or end layout");
            }
            case 5: {
                String field = BibDatabase.getText(this.text, databaseContext.getDatabase());
                if (this.option != null) {
                    for (LayoutFormatter anOption : this.option) {
                        field = anOption.format(field);
                    }
                }
                if (this.postFormatter != null) {
                    field = this.postFormatter.format(field);
                }
                return field;
            }
            case 8: {
                return encoding.displayName();
            }
            case 9: 
            case 10: {
                return databaseContext.getDatabasePath().map(Path::toAbsolutePath).map(Path::toString).orElse("");
            }
        }
        return "";
    }

    private void doOptionField(String s) {
        List<String> v = StringUtil.tokenizeToList(s, "\n");
        if (v.size() == 1) {
            this.text = v.getFirst();
        } else {
            this.text = v.getFirst().trim();
            this.option = this.getOptionalLayout(v.get(1));
            for (LayoutFormatter anOption : this.option) {
                if (!(anOption instanceof NotFoundFormatter)) continue;
                NotFoundFormatter formatter = (NotFoundFormatter)anOption;
                String notFound = formatter.getNotFound();
                this.invalidFormatter.add(notFound);
            }
        }
    }

    private LayoutFormatter getLayoutFormatterByName(String name) {
        return switch (name) {
            case "HTMLToLatexFormatter", "HtmlToLatex" -> new HtmlToLatexFormatter();
            case "UnicodeToLatexFormatter", "UnicodeToLatex" -> new UnicodeToLatexFormatter();
            case "OOPreFormatter" -> new OOPreFormatter();
            case "AuthorAbbreviator" -> new AuthorAbbreviator();
            case "AuthorAndToSemicolonReplacer" -> new AuthorAndToSemicolonReplacer();
            case "AuthorAndsCommaReplacer" -> new AuthorAndsCommaReplacer();
            case "AuthorAndsReplacer" -> new AuthorAndsReplacer();
            case "AuthorFirstAbbrLastCommas" -> new AuthorFirstAbbrLastCommas();
            case "AuthorFirstAbbrLastOxfordCommas" -> new AuthorFirstAbbrLastOxfordCommas();
            case "AuthorFirstFirst" -> new AuthorFirstFirst();
            case "AuthorFirstFirstCommas" -> new AuthorFirstFirstCommas();
            case "AuthorFirstLastCommas" -> new AuthorFirstLastCommas();
            case "AuthorFirstLastOxfordCommas" -> new AuthorFirstLastOxfordCommas();
            case "AuthorLastFirst" -> new AuthorLastFirst();
            case "AuthorLastFirstAbbrCommas" -> new AuthorLastFirstAbbrCommas();
            case "AuthorLastFirstAbbreviator" -> new AuthorLastFirstAbbreviator();
            case "AuthorLastFirstAbbrOxfordCommas" -> new AuthorLastFirstAbbrOxfordCommas();
            case "AuthorLastFirstCommas" -> new AuthorLastFirstCommas();
            case "AuthorLastFirstOxfordCommas" -> new AuthorLastFirstOxfordCommas();
            case "AuthorLF_FF" -> new AuthorLF_FF();
            case "AuthorLF_FFAbbr" -> new AuthorLF_FFAbbr();
            case "AuthorNatBib" -> new AuthorNatBib();
            case "AuthorOrgSci" -> new AuthorOrgSci();
            case "CompositeFormat" -> new CompositeFormat();
            case "CreateBibORDFAuthors" -> new CreateBibORDFAuthors();
            case "CreateDocBook4Authors" -> new CreateDocBook4Authors();
            case "CreateDocBook4Editors" -> new CreateDocBook4Editors();
            case "CreateDocBook5Authors" -> new CreateDocBook5Authors();
            case "CreateDocBook5Editors" -> new CreateDocBook5Editors();
            case "CurrentDate" -> new CurrentDate();
            case "DateFormatter" -> new DateFormatter();
            case "DOICheck" -> new DOICheck(this.preferences.getDoiPreferences());
            case "DOIStrip" -> new DOIStrip();
            case "EntryTypeFormatter" -> new EntryTypeFormatter();
            case "FirstPage" -> new FirstPage();
            case "FormatPagesForHTML" -> new FormatPagesForHTML();
            case "FormatPagesForXML" -> new FormatPagesForXML();
            case "GetOpenOfficeType" -> new GetOpenOfficeType();
            case "HTMLChars" -> new HTMLChars();
            case "HTMLParagraphs" -> new HTMLParagraphs();
            case "Iso690FormatDate" -> new Iso690FormatDate();
            case "Iso690NamesAuthors" -> new Iso690NamesAuthors();
            case "JournalAbbreviator" -> new JournalAbbreviator(this.abbreviationRepository);
            case "LastPage" -> new LastPage();
            case "FormatChars", "LatexToUnicode" -> new LatexToUnicodeFormatter();
            case "NameFormatter" -> new NameFormatter();
            case "NoSpaceBetweenAbbreviations" -> new NoSpaceBetweenAbbreviations();
            case "Ordinal" -> new Ordinal();
            case "RemoveBrackets" -> new RemoveBrackets();
            case "RemoveBracketsAddComma" -> new RemoveBracketsAddComma();
            case "RemoveLatexCommands" -> new RemoveLatexCommandsFormatter();
            case "RemoveTilde" -> new RemoveTilde();
            case "RemoveWhitespace" -> new RemoveWhitespace();
            case "RisKeywords" -> new RisKeywords();
            case "RisMonth" -> new RisMonth();
            case "RTFChars" -> new RTFChars();
            case "ToLowerCase" -> new ToLowerCase();
            case "ToUpperCase" -> new ToUpperCase();
            case "XMLChars" -> new XMLChars();
            case "Default" -> new Default();
            case "FileLink" -> new FileLink(this.fileDirForDatabase, this.preferences.getMainFileDirectory());
            case "Number" -> new Number();
            case "RisAuthors" -> new RisAuthors();
            case "Authors" -> new Authors();
            case "IfPlural" -> new IfPlural();
            case "Replace" -> new Replace();
            case "WrapContent" -> new WrapContent();
            case "WrapFileLinks" -> new WrapFileLinks(this.fileDirForDatabase, this.preferences.getMainFileDirectory());
            case "Markdown" -> new MarkdownFormatter();
            case "CSLType" -> new CSLType();
            case "ShortMonth" -> new ShortMonthFormatter();
            case "ReplaceWithEscapedDoubleQuotes" -> new ReplaceWithEscapedDoubleQuotes();
            case "HayagrivaType" -> new HayagrivaType();
            default -> null;
        };
    }

    private List<LayoutFormatter> getOptionalLayout(String formatterName) {
        List<List<String>> formatterStrings = LayoutEntry.parseMethodsCalls(formatterName);
        ArrayList<LayoutFormatter> results = new ArrayList<LayoutFormatter>(formatterStrings.size());
        Map<String, String> userNameFormatter = NameFormatter.getNameFormatters(this.preferences.getNameFormatterPreferences());
        for (List<String> strings : formatterStrings) {
            String nameFormatterName = strings.getFirst().trim();
            Optional<String> contents = this.preferences.getCustomExportNameFormatter(nameFormatterName);
            if (contents.isPresent()) {
                NameFormatter nf = new NameFormatter();
                nf.setParameter(contents.get());
                results.add(nf);
                continue;
            }
            LayoutFormatter formatter = this.getLayoutFormatterByName(nameFormatterName);
            if (formatter != null) {
                if (formatter instanceof ParamLayoutFormatter) {
                    ParamLayoutFormatter layoutFormatter = (ParamLayoutFormatter)formatter;
                    if (strings.size() >= 2) {
                        layoutFormatter.setArgument(strings.get(1));
                    }
                }
                results.add(formatter);
                continue;
            }
            String formatterParameter = userNameFormatter.get(nameFormatterName);
            if (formatterParameter != null) {
                NameFormatter nf = new NameFormatter();
                nf.setParameter(formatterParameter);
                results.add(nf);
                continue;
            }
            results.add(new NotFoundFormatter(nameFormatterName));
        }
        return results;
    }

    public List<String> getInvalidFormatters() {
        return this.invalidFormatter;
    }

    public static List<List<String>> parseMethodsCalls(String calls) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        char[] c = calls.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            String method;
            int start = i;
            if (!Character.isJavaIdentifierStart(c[i])) continue;
            ++i;
            while (i < c.length && (Character.isJavaIdentifierPart(c[i]) || c[i] == '.')) {
                ++i;
            }
            if (i < c.length && c[i] == '(') {
                method = calls.substring(start, i);
                int bracelevel = 0;
                if (++i < c.length) {
                    int startParam;
                    if (c[i] == '\"') {
                        startParam = ++i;
                        ++i;
                        boolean escaped = false;
                        while (i + 1 < c.length && (escaped || c[i] != '\"' || c[i + 1] != ')' || bracelevel != 0)) {
                            if (c[i] == '\\') {
                                escaped = !escaped;
                            } else if (c[i] == '(') {
                                ++bracelevel;
                            } else if (c[i] == ')') {
                                --bracelevel;
                            } else {
                                escaped = false;
                            }
                            ++i;
                        }
                        String param = calls.substring(startParam, i);
                        result.add(Arrays.asList(method, param));
                        continue;
                    }
                    startParam = i;
                    while (i < c.length && (c[i] != ')' || bracelevel != 0)) {
                        if (c[i] == '(') {
                            ++bracelevel;
                        } else if (c[i] == ')') {
                            --bracelevel;
                        }
                        ++i;
                    }
                    String param = calls.substring(startParam, i);
                    result.add(Arrays.asList(method, param));
                    continue;
                }
                result.add(Collections.singletonList(method));
                continue;
            }
            method = calls.substring(start, i);
            result.add(Collections.singletonList(method));
        }
        return result;
    }

    public String getText() {
        return this.text;
    }
}

