/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout.format;

import java.net.URI;
import org.jabref.logic.layout.LayoutFormatter;
import org.jabref.logic.preferences.DOIPreferences;
import org.jabref.model.entry.identifier.DOI;

public class DOICheck
implements LayoutFormatter {
    private final DOIPreferences doiPreferences;

    public DOICheck(DOIPreferences doiPreferences) {
        this.doiPreferences = doiPreferences;
    }

    @Override
    public String format(String fieldText) {
        if (fieldText == null) {
            return null;
        }
        String result = fieldText;
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        if (this.doiPreferences.isUseCustom()) {
            URI base = URI.create(this.doiPreferences.getDefaultBaseURI());
            return DOI.parse(result).flatMap(doi -> doi.getExternalURIFromBase(base)).map(URI::toASCIIString).orElse(result);
        }
        return DOI.parse(result).map(DOI::getURIAsASCIIString).orElse(result);
    }
}

