/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout.format;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.jabref.logic.importer.util.FileFieldParser;
import org.jabref.logic.layout.ParamLayoutFormatter;
import org.jabref.model.entry.LinkedFile;

public class FileLink
implements ParamLayoutFormatter {
    private final List<Path> fileDirectories;
    private final String mainFileDirectory;
    private String fileType;

    public FileLink(List<Path> fileDirectories, String mainFileDirectory) {
        this.fileDirectories = fileDirectories;
        this.mainFileDirectory = mainFileDirectory;
    }

    @Override
    public String format(String field) {
        LinkedFile link;
        block4: {
            List<LinkedFile> fileList;
            block3: {
                if (field == null) {
                    return "";
                }
                fileList = FileFieldParser.parse(field);
                link = null;
                if (this.fileType != null) break block3;
                if (fileList.isEmpty()) break block4;
                link = fileList.getFirst();
                break block4;
            }
            for (LinkedFile flEntry : fileList) {
                if (!flEntry.getFileType().equalsIgnoreCase(this.fileType)) continue;
                link = flEntry;
                break;
            }
        }
        if (link == null) {
            return "";
        }
        List<Path> dirs = this.fileDirectories.isEmpty() ? Collections.singletonList(Path.of(this.mainFileDirectory, new String[0])) : this.fileDirectories;
        return link.findIn(dirs).map(path -> path.normalize().toString()).orElse(link.getLink());
    }

    @Override
    public void setArgument(String arg) {
        this.fileType = arg;
    }
}

