/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.msbib;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jabref.logic.msbib.MSBibEntry;
import org.jabref.logic.msbib.MSBibMapping;
import org.jabref.logic.msbib.MsBibAuthor;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Month;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.entry.types.EntryType;

public class BibTeXConverter {
    private static final String MSBIB_PREFIX = "msbib-";

    private BibTeXConverter() {
    }

    public static BibEntry convert(MSBibEntry entry) {
        HashMap<Field, String> fieldValues = new HashMap<Field, String>();
        EntryType bibTexEntryType = MSBibMapping.getBiblatexEntryType(entry.getType());
        BibEntry result = new BibEntry(bibTexEntryType);
        for (Map.Entry<String, String> field : entry.fields.entrySet()) {
            String msField = field.getKey();
            String value = field.getValue();
            if (value == null || MSBibMapping.getBibTeXField(msField) == null) continue;
            fieldValues.put(MSBibMapping.getBibTeXField(msField), value);
        }
        if (fieldValues.containsKey(StandardField.LANGUAGE)) {
            int lcid = Integer.valueOf((String)fieldValues.get(StandardField.LANGUAGE));
            fieldValues.put(StandardField.LANGUAGE, MSBibMapping.getLanguage(lcid));
        }
        BibTeXConverter.addAuthor(fieldValues, StandardField.AUTHOR, entry.authors);
        BibTeXConverter.addAuthor(fieldValues, StandardField.BOOKAUTHOR, entry.bookAuthors);
        BibTeXConverter.addAuthor(fieldValues, StandardField.EDITOR, entry.editors);
        BibTeXConverter.addAuthor(fieldValues, StandardField.TRANSLATOR, entry.translators);
        BibTeXConverter.addAuthor(fieldValues, new UnknownField("msbib-producername"), entry.producerNames);
        BibTeXConverter.addAuthor(fieldValues, new UnknownField("msbib-composer"), entry.composers);
        BibTeXConverter.addAuthor(fieldValues, new UnknownField("msbib-conductor"), entry.conductors);
        BibTeXConverter.addAuthor(fieldValues, new UnknownField("msbib-performer"), entry.performers);
        BibTeXConverter.addAuthor(fieldValues, new UnknownField("msbib-writer"), entry.writers);
        BibTeXConverter.addAuthor(fieldValues, new UnknownField("msbib-director"), entry.directors);
        BibTeXConverter.addAuthor(fieldValues, new UnknownField("msbib-compiler"), entry.compilers);
        BibTeXConverter.addAuthor(fieldValues, new UnknownField("msbib-interviewer"), entry.interviewers);
        BibTeXConverter.addAuthor(fieldValues, new UnknownField("msbib-interviewee"), entry.interviewees);
        BibTeXConverter.addAuthor(fieldValues, new UnknownField("msbib-inventor"), entry.inventors);
        BibTeXConverter.addAuthor(fieldValues, new UnknownField("msbib-counsel"), entry.counsels);
        if (entry.pages != null) {
            fieldValues.put(StandardField.PAGES, entry.pages.toString("--"));
        }
        BibTeXConverter.parseStandardNumber(entry.standardNumber, fieldValues);
        if (entry.address != null) {
            fieldValues.put(StandardField.LOCATION, entry.address);
        }
        if (entry.conferenceName != null) {
            fieldValues.put(StandardField.ORGANIZATION, entry.conferenceName);
        }
        if (entry.dateAccessed != null) {
            fieldValues.put(new UnknownField("msbib-accessed"), entry.dateAccessed);
        }
        if (entry.journalName != null) {
            fieldValues.put(StandardField.JOURNAL, entry.journalName);
        }
        if (entry.month != null) {
            Optional<Month> month = Month.parse(entry.month);
            month.ifPresent(result::setMonth);
        }
        if (entry.number != null) {
            fieldValues.put(StandardField.NUMBER, entry.number);
        }
        result.setField(fieldValues);
        return result;
    }

    private static void addAuthor(Map<Field, String> map, Field field, List<MsBibAuthor> authors) {
        if (authors == null) {
            return;
        }
        String allAuthors = authors.stream().map(MsBibAuthor::getLastFirst).collect(Collectors.joining(" and "));
        map.put(field, allAuthors);
    }

    private static void parseSingleStandardNumber(String type, Field field, String standardNum, Map<Field, String> map) {
        Pattern pattern = Pattern.compile(":" + type + ":(.[^:]+)");
        Matcher matcher = pattern.matcher(standardNum);
        if (matcher.matches()) {
            map.put(field, matcher.group(1));
        }
    }

    private static void parseStandardNumber(String standardNum, Map<Field, String> map) {
        if (standardNum == null) {
            return;
        }
        BibTeXConverter.parseSingleStandardNumber("ISBN", StandardField.ISBN, standardNum, map);
        BibTeXConverter.parseSingleStandardNumber("ISSN", StandardField.ISSN, standardNum, map);
        BibTeXConverter.parseSingleStandardNumber("LCCN", new UnknownField("lccn"), standardNum, map);
        BibTeXConverter.parseSingleStandardNumber("MRN", StandardField.MR_NUMBER, standardNum, map);
        BibTeXConverter.parseSingleStandardNumber("DOI", StandardField.DOI, standardNum, map);
    }
}

