/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.action;

import com.sun.star.beans.IllegalTypeException;
import com.sun.star.beans.NotRemoveableException;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jabref.logic.openoffice.frontend.OOFrontend;
import org.jabref.logic.openoffice.frontend.UpdateCitationMarkers;
import org.jabref.logic.openoffice.style.OOBibStyle;
import org.jabref.model.openoffice.ootext.OOText;
import org.jabref.model.openoffice.style.Citation;
import org.jabref.model.openoffice.style.CitationGroup;
import org.jabref.model.openoffice.style.CitationType;
import org.jabref.model.openoffice.uno.CreationException;
import org.jabref.model.openoffice.uno.NoDocumentException;
import org.jabref.model.openoffice.uno.UnoScreenRefresh;
import org.jabref.model.openoffice.uno.UnoTextRange;
import org.jabref.model.openoffice.util.OOListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditMerge {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditMerge.class);

    private EditMerge() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mergeCitationGroups(XTextDocument doc, OOFrontend frontend, OOBibStyle style) throws CreationException, IllegalArgumentException, IllegalTypeException, NoDocumentException, NotRemoveableException, PropertyVetoException, WrappedTargetException {
        boolean madeModifications;
        try {
            UnoScreenRefresh.lockControllers(doc);
            List<JoinableGroupData> joinableGroups = EditMerge.scan(doc, frontend);
            for (JoinableGroupData joinableGroupData : joinableGroups) {
                List<CitationGroup> groups = joinableGroupData.group;
                List newCitations = groups.stream().flatMap(group -> group.citationsInStorageOrder.stream()).collect(Collectors.toList());
                CitationType citationType = groups.getFirst().citationType;
                List<Optional<OOText>> pageInfos = frontend.backend.combinePageInfos(groups);
                frontend.removeCitationGroups(groups, doc);
                XTextCursor textCursor = joinableGroupData.groupCursor;
                textCursor.setString("");
                List<String> citationKeys = OOListUtil.map(newCitations, Citation::getCitationKey);
                boolean insertSpaceAfter = false;
                UpdateCitationMarkers.createAndFillCitationGroup(frontend, doc, citationKeys, pageInfos, citationType, OOText.fromString("tmp"), textCursor, style, insertSpaceAfter);
            }
            madeModifications = !joinableGroups.isEmpty();
        }
        finally {
            UnoScreenRefresh.unlockControllers(doc);
        }
        return madeModifications;
    }

    private static boolean checkAddToGroup(ScanState state, CitationGroup group, XTextRange currentRange) {
        if (state.currentGroup.isEmpty()) {
            return false;
        }
        Objects.requireNonNull(state.currentGroupCursor);
        Objects.requireNonNull(state.cursorBetween);
        Objects.requireNonNull(state.prev);
        Objects.requireNonNull(state.prevRange);
        if (group.citationType != CitationType.AUTHORYEAR_PAR) {
            return false;
        }
        if (state.prev != null) {
            if (group.citationType != state.prev.citationType) {
                return false;
            }
            if (!UnoTextRange.comparables(state.prevRange, currentRange)) {
                return false;
            }
            int textOrder = UnoTextRange.compareStarts(state.prevRange, currentRange);
            if (textOrder != -1) {
                String msg = "MergeCitationGroups: \"%s\" supposed to be followed by \"%s\", but %s".formatted(state.prevRange.getString(), currentRange.getString(), textOrder == 0 ? "they start at the same position" : "the start of the latter precedes the start of the first");
                LOGGER.warn(msg);
                return false;
            }
        }
        if (state.cursorBetween == null) {
            return false;
        }
        Objects.requireNonNull(state.cursorBetween);
        Objects.requireNonNull(state.currentGroupCursor);
        if (UnoTextRange.compareEnds((XTextRange)state.cursorBetween, (XTextRange)state.currentGroupCursor) != 0) {
            LOGGER.warn("MergeCitationGroups: cursorBetween.end != currentGroupCursor.end");
            throw new IllegalStateException("MergeCitationGroups failed");
        }
        XTextRange rangeStart = currentRange.getStart();
        boolean couldExpand = true;
        XTextCursor thisCharCursor = currentRange.getText().createTextCursorByRange(state.cursorBetween.getEnd());
        while (couldExpand && UnoTextRange.compareEnds((XTextRange)state.cursorBetween, rangeStart) < 0) {
            couldExpand = thisCharCursor.goRight((short)1, true);
            String thisChar = thisCharCursor.getString();
            thisCharCursor.collapseToEnd();
            if (thisChar.isEmpty() || "\n".equals(thisChar) || !thisChar.trim().isEmpty()) {
                couldExpand = false;
                if (thisChar.isEmpty()) break;
                thisCharCursor.goLeft((short)1, false);
                break;
            }
            state.cursorBetween.goRight((short)1, true);
            state.currentGroupCursor.goRight((short)1, true);
            if (UnoTextRange.compareEnds((XTextRange)state.cursorBetween, (XTextRange)state.currentGroupCursor) == 0) continue;
            LOGGER.warn("MergeCitationGroups: cursorBetween.end != currentGroupCursor.end (during expand)");
            throw new IllegalStateException("MergeCitationGroups failed");
        }
        return couldExpand;
    }

    private static void addToCurrentGroup(ScanState state, CitationGroup group, XTextRange currentRange) {
        boolean isNewGroup = state.currentGroup.isEmpty();
        if (!isNewGroup) {
            Objects.requireNonNull(state.currentGroupCursor);
            Objects.requireNonNull(state.cursorBetween);
            Objects.requireNonNull(state.prev);
            Objects.requireNonNull(state.prevRange);
        }
        state.currentGroup.add(group);
        XTextRange rangeEnd = currentRange.getEnd();
        state.cursorBetween = currentRange.getText().createTextCursorByRange(rangeEnd);
        if (isNewGroup) {
            state.currentGroupCursor = currentRange.getText().createTextCursorByRange(currentRange.getStart());
        }
        state.currentGroupCursor.goRight((short)currentRange.getString().length(), true);
        if (UnoTextRange.compareEnds((XTextRange)state.cursorBetween, (XTextRange)state.currentGroupCursor) != 0) {
            LOGGER.warn("MergeCitationGroups: cursorBetween.end != currentGroupCursor.end");
            throw new IllegalStateException("MergeCitationGroups failed");
        }
        state.prev = group;
        state.prevRange = currentRange;
    }

    private static List<JoinableGroupData> scan(XTextDocument doc, OOFrontend frontend) throws NoDocumentException, WrappedTargetException {
        ArrayList<JoinableGroupData> result = new ArrayList<JoinableGroupData>();
        List<CitationGroup> groups = frontend.getCitationGroupsSortedWithinPartitions(doc, false);
        if (groups.isEmpty()) {
            return result;
        }
        ScanState state = new ScanState();
        for (CitationGroup group : groups) {
            boolean canStartGroup;
            XTextRange currentRange = frontend.getMarkRange(doc, group).orElseThrow(IllegalStateException::new);
            boolean addToGroup = EditMerge.checkAddToGroup(state, group, currentRange);
            boolean bl = canStartGroup = group.citationType == CitationType.AUTHORYEAR_PAR;
            if (!addToGroup) {
                if (state.currentGroup.size() > 1) {
                    result.add(new JoinableGroupData(state.currentGroup, state.currentGroupCursor));
                }
                state.reset();
            }
            if (!addToGroup && !canStartGroup) continue;
            EditMerge.addToCurrentGroup(state, group, currentRange);
        }
        if (state.currentGroup.size() > 1) {
            result.add(new JoinableGroupData(state.currentGroup, state.currentGroupCursor));
        }
        return result;
    }

    private static class JoinableGroupData {
        List<CitationGroup> group;
        XTextCursor groupCursor;

        JoinableGroupData(List<CitationGroup> group, XTextCursor groupCursor) {
            this.group = group;
            this.groupCursor = groupCursor;
        }
    }

    private static class ScanState {
        List<CitationGroup> currentGroup;
        XTextCursor currentGroupCursor;
        XTextCursor cursorBetween;
        CitationGroup prev;
        XTextRange prevRange;

        ScanState() {
            this.reset();
        }

        void reset() {
            this.currentGroup = new ArrayList<CitationGroup>();
            this.currentGroupCursor = null;
            this.cursorBetween = null;
            this.prev = null;
            this.prevRange = null;
        }
    }
}

