/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.backend;

import com.sun.star.beans.IllegalTypeException;
import com.sun.star.beans.NotRemoveableException;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jabref.logic.openoffice.backend.Codec52;
import org.jabref.logic.openoffice.backend.GetContext;
import org.jabref.logic.openoffice.backend.NamedRangeManagerReferenceMark;
import org.jabref.model.openoffice.CitationEntry;
import org.jabref.model.openoffice.backend.NamedRange;
import org.jabref.model.openoffice.backend.NamedRangeManager;
import org.jabref.model.openoffice.ootext.OOText;
import org.jabref.model.openoffice.style.Citation;
import org.jabref.model.openoffice.style.CitationGroup;
import org.jabref.model.openoffice.style.CitationGroupId;
import org.jabref.model.openoffice.style.CitationGroups;
import org.jabref.model.openoffice.style.CitationType;
import org.jabref.model.openoffice.style.OODataModel;
import org.jabref.model.openoffice.style.PageInfo;
import org.jabref.model.openoffice.uno.CreationException;
import org.jabref.model.openoffice.uno.NoDocumentException;
import org.jabref.model.openoffice.uno.UnoUserDefinedProperty;
import org.jabref.model.openoffice.util.OOListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Backend52 {
    private static final Logger LOGGER = LoggerFactory.getLogger(Backend52.class);
    public final OODataModel dataModel = OODataModel.JabRef52;
    private final NamedRangeManager citationStorageManager = new NamedRangeManagerReferenceMark();
    private final Map<CitationGroupId, NamedRange> cgidToNamedRange = new HashMap<CitationGroupId, NamedRange>();

    public List<String> getJabRefReferenceMarkNames(XTextDocument doc) throws NoDocumentException {
        List<String> allNames = this.citationStorageManager.getUsedNames(doc);
        return Codec52.filterIsJabRefReferenceMarkName(allNames);
    }

    private List<String> findUnusedJabrefPropertyNames(XTextDocument doc, List<String> citationGroupNames) {
        HashSet<String> citationGroupNamesSet = new HashSet<String>(citationGroupNames);
        ArrayList<String> pageInfoThrash = new ArrayList<String>();
        List<String> jabrefPropertyNames = UnoUserDefinedProperty.getListOfNames(doc).stream().filter(Codec52::isJabRefReferenceMarkName).toList();
        for (String pn : jabrefPropertyNames) {
            if (citationGroupNamesSet.contains(pn)) continue;
            pageInfoThrash.add(pn);
        }
        return pageInfoThrash;
    }

    public Optional<String> healthReport(XTextDocument doc) throws NoDocumentException {
        List<String> pageInfoThrash = this.findUnusedJabrefPropertyNames(doc, this.getJabRefReferenceMarkNames(doc));
        if (pageInfoThrash.isEmpty()) {
            return Optional.empty();
        }
        String msg = "Backend52: found unused pageInfo data, with names listed below.\nIn LibreOffice you may remove these in [File]/[Properties]/[Custom Properties]\n" + String.join((CharSequence)"\n", pageInfoThrash);
        return Optional.of(msg);
    }

    private static void setPageInfoInDataInitial(List<Citation> citations, Optional<OOText> pageInfo) {
        if (!citations.isEmpty()) {
            citations.getLast().setPageInfo(pageInfo);
        }
    }

    private static Optional<OOText> getPageInfoFromData(CitationGroup group) {
        List<Citation> citations = group.getCitationsInLocalOrder();
        if (citations.isEmpty()) {
            return Optional.empty();
        }
        return citations.getLast().getPageInfo();
    }

    public CitationGroup readCitationGroupFromDocumentOrThrow(XTextDocument doc, String markName) throws WrappedTargetException, NoDocumentException {
        Codec52.ParsedMarkName parsed = Codec52.parseMarkName(markName).orElseThrow(IllegalArgumentException::new);
        List<Citation> citations = parsed.citationKeys.stream().map(Citation::new).collect(Collectors.toList());
        Optional<OOText> pageInfo = UnoUserDefinedProperty.getStringValue(doc, markName).map(OOText::fromString);
        pageInfo = PageInfo.normalizePageInfo(pageInfo);
        Backend52.setPageInfoInDataInitial(citations, pageInfo);
        NamedRange namedRange = this.citationStorageManager.getNamedRangeFromDocument(doc, markName).orElseThrow(IllegalArgumentException::new);
        CitationGroupId groupId = new CitationGroupId(markName);
        CitationGroup group = new CitationGroup(OODataModel.JabRef52, groupId, parsed.citationType, citations, Optional.of(markName));
        this.cgidToNamedRange.put(groupId, namedRange);
        return group;
    }

    public CitationGroup createCitationGroup(XTextDocument doc, List<String> citationKeys, List<Optional<OOText>> pageInfos, CitationType citationType, XTextCursor position, boolean insertSpaceAfter) throws CreationException, NoDocumentException, WrappedTargetException, NotRemoveableException, PropertyVetoException, IllegalTypeException {
        Objects.requireNonNull(pageInfos);
        if (pageInfos.size() != citationKeys.size()) {
            throw new IllegalArgumentException();
        }
        int numberOfCitations = citationKeys.size();
        int last = numberOfCitations - 1;
        ArrayList<Citation> citations = new ArrayList<Citation>(numberOfCitations);
        block8: for (int i = 0; i < numberOfCitations; ++i) {
            Citation cit = new Citation(citationKeys.get(i));
            citations.add(cit);
            Optional<OOText> pageInfo = PageInfo.normalizePageInfo(pageInfos.get(i));
            switch (this.dataModel) {
                case JabRef52: {
                    if (i == last) {
                        cit.setPageInfo(pageInfo);
                        continue block8;
                    }
                    if (!pageInfo.isPresent()) continue block8;
                    LOGGER.warn("dataModel JabRef52 only supports pageInfo for the last citation of a group");
                    continue block8;
                }
                case JabRef60: {
                    cit.setPageInfo(pageInfo);
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("Unhandled dataModel in Backend52.createCitationGroup");
                }
            }
        }
        String markName = Codec52.getUniqueMarkName(new HashSet<String>(this.citationStorageManager.getUsedNames(doc)), citationKeys, citationType);
        CitationGroupId groupId = new CitationGroupId(markName);
        boolean withoutBrackets = citationType == CitationType.INVISIBLE_CIT;
        NamedRange namedRange = this.citationStorageManager.createNamedRange(doc, markName, position, insertSpaceAfter, withoutBrackets);
        switch (this.dataModel) {
            case JabRef52: {
                Optional<OOText> pageInfo = PageInfo.normalizePageInfo(pageInfos.get(last));
                if (pageInfo.isPresent()) {
                    String pageInfoString = OOText.toString(pageInfo.get());
                    UnoUserDefinedProperty.setStringProperty(doc, markName, pageInfoString);
                } else {
                    UnoUserDefinedProperty.removeIfExists(doc, markName);
                }
                CitationGroup group = new CitationGroup(OODataModel.JabRef52, groupId, citationType, citations, Optional.of(markName));
                this.cgidToNamedRange.put(groupId, namedRange);
                return group;
            }
            case JabRef60: {
                throw new IllegalStateException("createCitationGroup for JabRef60 is not implemented yet");
            }
        }
        throw new IllegalStateException("Unhandled dataModel in Backend52.createCitationGroup");
    }

    public static List<Optional<OOText>> combinePageInfosCommon(OODataModel dataModel, List<CitationGroup> joinableGroup) {
        switch (dataModel) {
            case JabRef52: {
                List<Optional> pageInfos = OOListUtil.map(joinableGroup, Backend52::getPageInfoFromData);
                String singlePageInfo = pageInfos.stream().filter(Optional::isPresent).map(pi -> OOText.toString((OOText)pi.get())).distinct().collect(Collectors.joining("; "));
                int totalCitations = joinableGroup.stream().map(CitationGroup::numberOfCitations).mapToInt(Integer::intValue).sum();
                if ("".equals(singlePageInfo)) {
                    singlePageInfo = null;
                }
                return OODataModel.fakePageInfos(singlePageInfo, totalCitations);
            }
            case JabRef60: {
                return joinableGroup.stream().flatMap(group -> group.citationsInStorageOrder.stream().map(Citation::getPageInfo)).collect(Collectors.toList());
            }
        }
        throw new IllegalArgumentException("unhandled dataModel here");
    }

    public List<Optional<OOText>> combinePageInfos(List<CitationGroup> joinableGroup) {
        return Backend52.combinePageInfosCommon(this.dataModel, joinableGroup);
    }

    private NamedRange getNamedRangeOrThrow(CitationGroup group) {
        NamedRange namedRange = this.cgidToNamedRange.get(group.groupId);
        if (namedRange == null) {
            throw new IllegalStateException("getNamedRange: could not lookup namedRange");
        }
        return namedRange;
    }

    public void removeCitationGroup(CitationGroup group, XTextDocument doc) throws WrappedTargetException, NoDocumentException, NotRemoveableException {
        NamedRange namedRange = this.getNamedRangeOrThrow(group);
        String refMarkName = namedRange.getRangeName();
        namedRange.removeFromDocument(doc);
        UnoUserDefinedProperty.removeIfExists(doc, refMarkName);
        this.cgidToNamedRange.remove(group.groupId);
    }

    public Optional<XTextRange> getMarkRange(CitationGroup group, XTextDocument doc) throws NoDocumentException, WrappedTargetException {
        NamedRange namedRange = this.getNamedRangeOrThrow(group);
        return namedRange.getMarkRange(doc);
    }

    public Optional<XTextCursor> getRawCursorForCitationGroup(CitationGroup group, XTextDocument doc) throws NoDocumentException, WrappedTargetException {
        NamedRange namedRange = this.getNamedRangeOrThrow(group);
        return namedRange.getRawCursor(doc);
    }

    public XTextCursor getFillCursorForCitationGroup(CitationGroup group, XTextDocument doc) throws NoDocumentException, WrappedTargetException, CreationException {
        NamedRange namedRange = this.getNamedRangeOrThrow(group);
        return namedRange.getFillCursor(doc);
    }

    public void cleanFillCursorForCitationGroup(CitationGroup group, XTextDocument doc) throws NoDocumentException, WrappedTargetException {
        NamedRange namedRange = this.getNamedRangeOrThrow(group);
        namedRange.cleanFillCursor(doc);
    }

    public List<CitationEntry> getCitationEntries(XTextDocument doc, CitationGroups citationGroups) throws WrappedTargetException, NoDocumentException {
        switch (this.dataModel) {
            case JabRef52: {
                ArrayList<CitationEntry> citations = new ArrayList<CitationEntry>(citationGroups.numberOfCitationGroups());
                for (CitationGroup group : citationGroups.getCitationGroupsUnordered()) {
                    String name = group.groupId.citationGroupIdAsString();
                    XTextCursor cursor = this.getRawCursorForCitationGroup(group, doc).orElseThrow(IllegalStateException::new);
                    String context = GetContext.getCursorStringWithContext(cursor, 30, 30, true);
                    Optional<String> pageInfo = group.numberOfCitations() > 0 ? Backend52.getPageInfoFromData(group).map(e -> OOText.toString(e)) : Optional.empty();
                    CitationEntry entry = new CitationEntry(name, context, pageInfo);
                    citations.add(entry);
                }
                return citations;
            }
            case JabRef60: {
                throw new IllegalStateException("getCitationEntries for JabRef60 is not implemented yet");
            }
        }
        throw new IllegalStateException("getCitationEntries: unhandled dataModel ");
    }

    public void applyCitationEntries(XTextDocument doc, List<CitationEntry> citationEntries) throws PropertyVetoException, IllegalTypeException, IllegalArgumentException, WrappedTargetException {
        switch (this.dataModel) {
            case JabRef52: {
                for (CitationEntry entry : citationEntries) {
                    Optional<OOText> pageInfo = entry.getPageInfo().map(OOText::fromString);
                    if (!(pageInfo = PageInfo.normalizePageInfo(pageInfo)).isPresent()) continue;
                    String name = entry.getRefMarkName();
                    UnoUserDefinedProperty.setStringProperty(doc, name, pageInfo.get().toString());
                }
                break;
            }
            case JabRef60: {
                throw new IllegalStateException("applyCitationEntries for JabRef60 is not implemented yet");
            }
            default: {
                throw new IllegalStateException("applyCitationEntries: unhandled dataModel ");
            }
        }
    }
}

