/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.backend;

import com.sun.star.text.XTextCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetContext.class);

    private GetContext() {
    }

    public static String getCursorStringWithContext(XTextCursor cursor, int charBefore, int charAfter, boolean htmlMarkup) {
        String citPart = cursor.getString();
        int flex = 8;
        for (int i = 0; i < charBefore; ++i) {
            try {
                cursor.goLeft((short)1, true);
                if (i < charBefore - flex || !Character.isWhitespace(cursor.getString().charAt(0))) continue;
                break;
            }
            catch (IndexOutOfBoundsException ex) {
                LOGGER.warn("Problem going left", (Throwable)ex);
            }
        }
        int lengthWithBefore = cursor.getString().length();
        int addedBefore = lengthWithBefore - citPart.length();
        cursor.collapseToStart();
        for (int i = 0; i < charAfter + lengthWithBefore; ++i) {
            try {
                String strNow;
                cursor.goRight((short)1, true);
                if (i < charAfter + lengthWithBefore - flex || !Character.isWhitespace((strNow = cursor.getString()).charAt(strNow.length() - 1))) continue;
                break;
            }
            catch (IndexOutOfBoundsException ex) {
                LOGGER.warn("Problem going right", (Throwable)ex);
            }
        }
        Object result = cursor.getString();
        if (htmlMarkup) {
            result = ((String)result).substring(0, addedBefore) + "<b>" + citPart + "</b>" + ((String)result).substring(lengthWithBefore);
        }
        return ((String)result).trim();
    }
}

