/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.backend;

import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import java.util.Optional;
import org.jabref.model.openoffice.DocumentAnnotation;
import org.jabref.model.openoffice.backend.NamedRange;
import org.jabref.model.openoffice.uno.CreationException;
import org.jabref.model.openoffice.uno.NoDocumentException;
import org.jabref.model.openoffice.uno.UnoCursor;
import org.jabref.model.openoffice.uno.UnoReferenceMark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NamedRangeReferenceMark
implements NamedRange {
    private static final String ZERO_WIDTH_SPACE = "\u200b";
    private static final boolean REFERENCE_MARK_USE_INVISIBLE_BRACKETS = true;
    public static final String REFERENCE_MARK_LEFT_BRACKET = "\u200b";
    public static final String REFERENCE_MARK_RIGHT_BRACKET = "\u200b";
    private static final Logger LOGGER = LoggerFactory.getLogger(NamedRangeReferenceMark.class);
    private final String rangeId;

    private NamedRangeReferenceMark(String rangeId) {
        this.rangeId = rangeId;
    }

    String getId() {
        return this.rangeId;
    }

    private static XTextCursor safeInsertSpacesBetweenReferenceMarks(XTextRange position, int numSpaces) {
        XText text = position.getText();
        XTextCursor cursor = text.createTextCursorByRange(position.getStart());
        text.insertString((XTextRange)cursor, "\r\r", false);
        cursor.goLeft((short)1, false);
        text.insertString((XTextRange)cursor, " ".repeat(numSpaces), false);
        cursor.goRight((short)1, true);
        cursor.setString("");
        cursor.goLeft((short)numSpaces, false);
        cursor.goLeft((short)1, true);
        cursor.setString("");
        cursor.goRight((short)numSpaces, true);
        return cursor;
    }

    private static void createReprInDocument(XTextDocument doc, String refMarkName, XTextCursor position, boolean insertSpaceAfter, boolean withoutBrackets) throws CreationException {
        position.collapseToEnd();
        XTextCursor cursor = NamedRangeReferenceMark.safeInsertSpacesBetweenReferenceMarks(position.getEnd(), 2);
        XTextCursor cursorBefore = cursor.getText().createTextCursorByRange(cursor.getStart());
        XTextCursor cursorAfter = cursor.getText().createTextCursorByRange(cursor.getEnd());
        cursor.collapseToStart();
        cursor.goRight((short)1, false);
        String left = "\u200b";
        String right = "\u200b";
        String bracketedContent = withoutBrackets ? "" : "\u200b\u200b";
        cursor.getText().insertString((XTextRange)cursor, bracketedContent, true);
        DocumentAnnotation documentAnnotation = new DocumentAnnotation(doc, refMarkName, (XTextRange)cursor, true);
        UnoReferenceMark.create(documentAnnotation);
        cursorBefore.goRight((short)1, true);
        cursorBefore.setString("");
        if (!insertSpaceAfter) {
            cursorAfter.goLeft((short)1, true);
            cursorAfter.setString("");
        }
    }

    static NamedRangeReferenceMark create(XTextDocument doc, String refMarkName, XTextCursor position, boolean insertSpaceAfter, boolean withoutBrackets) throws CreationException {
        NamedRangeReferenceMark.createReprInDocument(doc, refMarkName, position, insertSpaceAfter, withoutBrackets);
        return new NamedRangeReferenceMark(refMarkName);
    }

    static Optional<NamedRangeReferenceMark> getFromDocument(XTextDocument doc, String refMarkName) throws NoDocumentException, WrappedTargetException {
        return UnoReferenceMark.getAnchor(doc, refMarkName).map(e -> new NamedRangeReferenceMark(refMarkName));
    }

    @Override
    public void removeFromDocument(XTextDocument doc) throws WrappedTargetException, NoDocumentException {
        UnoReferenceMark.removeIfExists(doc, this.getRangeName());
    }

    @Override
    public String getRangeName() {
        return this.rangeId;
    }

    @Override
    public Optional<XTextRange> getMarkRange(XTextDocument doc) throws NoDocumentException, WrappedTargetException {
        String name = this.getRangeName();
        return UnoReferenceMark.getAnchor(doc, name);
    }

    @Override
    public Optional<XTextCursor> getRawCursor(XTextDocument doc) throws NoDocumentException, WrappedTargetException {
        Optional<XTextCursor> full;
        String name = this.getRangeName();
        Optional<XTextContent> markAsTextContent = UnoReferenceMark.getAsTextContent(doc, name);
        if (markAsTextContent.isEmpty()) {
            LOGGER.warn("getRawCursor: markAsTextContent({}).isEmpty()", (Object)name);
        }
        if ((full = UnoCursor.getTextCursorOfTextContentAnchor(markAsTextContent.get())).isEmpty()) {
            LOGGER.warn("getRawCursor: full.isEmpty()");
            return Optional.empty();
        }
        return full;
    }

    @Override
    public XTextCursor getFillCursor(XTextDocument doc) throws NoDocumentException, WrappedTargetException, CreationException {
        String name = this.getRangeName();
        boolean debugThisFun = false;
        XTextCursor full = null;
        String fullText = null;
        for (int i = 1; i <= 2; ++i) {
            Optional<XTextContent> markAsTextContent = UnoReferenceMark.getAsTextContent(doc, name);
            if (markAsTextContent.isEmpty()) {
                String msg = "getFillCursor: markAsTextContent(%s).isEmpty (attempt %d)".formatted(name, i);
                throw new IllegalStateException(msg);
            }
            full = UnoCursor.getTextCursorOfTextContentAnchor(markAsTextContent.get()).orElse(null);
            if (full == null) {
                String msg = "getFillCursor: full == null (attempt %d)".formatted(i);
                throw new IllegalStateException(msg);
            }
            fullText = full.getString();
            LOGGER.debug("getFillCursor: fulltext = '{}'", (Object)fullText);
            if (fullText.length() >= 2) {
                LOGGER.debug("getFillCursor: (attempt: {}) fulltext.length() >= 2, break loop%n", (Object)i);
                break;
            }
            if (i == 2) {
                String msg = "getFillCursor: (fullText.length() < 2) (attempt %d)".formatted(i);
                throw new IllegalStateException(msg);
            }
            LOGGER.warn("getFillCursor: too short, recreate");
            full.setString("");
            UnoReferenceMark.removeIfExists(doc, name);
            boolean insertSpaceAfter = false;
            boolean withoutBrackets = false;
            NamedRangeReferenceMark.createReprInDocument(doc, name, full, false, false);
        }
        if (full == null) {
            throw new IllegalStateException("getFillCursorFor: full == null (after loop)");
        }
        if (fullText == null) {
            throw new IllegalStateException("getFillCursor: fullText == null (after loop)");
        }
        fullText = full.getString();
        if (fullText.length() < 2) {
            throw new IllegalStateException("getFillCursor: fullText.length() < 2 (after loop)'%n");
        }
        XTextCursor beta = full.getText().createTextCursorByRange((XTextRange)full);
        beta.collapseToStart();
        beta.goRight((short)1, false);
        beta.goRight((short)(fullText.length() - 2), true);
        LOGGER.debug("getFillCursor: beta(1) covers '{}'", (Object)beta.getString());
        String left = "\u200b";
        String right = "\u200b";
        short rightLength = (short)"\u200b".length();
        if (fullText.startsWith("\u200b") && fullText.endsWith("\u200b")) {
            beta.setString("");
        } else {
            LOGGER.debug("getFillCursor: recreating brackets for '{}'", (Object)fullText);
            XTextCursor alpha = full.getText().createTextCursorByRange((XTextRange)full);
            alpha.collapseToStart();
            XTextCursor omega = full.getText().createTextCursorByRange((XTextRange)full);
            omega.collapseToEnd();
            String paddingx = "x";
            String paddingy = "y";
            String paddingz = "z";
            beta.setString(paddingx + "\u200b" + paddingy + "\u200b" + paddingz);
            LOGGER.debug("getFillCursor: beta(2) covers '{}'", (Object)beta.getString());
            beta.collapseToEnd();
            beta.goLeft((short)(rightLength + 1), false);
            beta.goLeft((short)1, true);
            LOGGER.debug("getFillCursor: beta(3) covers '{}'", (Object)beta.getString());
            alpha.collapseToStart();
            alpha.goRight((short)2, true);
            LOGGER.debug("getFillCursor: alpha(4) covers '{}'", (Object)alpha.getString());
            alpha.setString("");
            omega.collapseToEnd();
            omega.goLeft((short)2, true);
            LOGGER.debug("getFillCursor: omega(5) covers '{}'", (Object)omega.getString());
            omega.setString("");
            LOGGER.debug("getFillCursor: beta(6) covers '{}'", (Object)beta.getString());
            beta.setString("");
        }
        return beta;
    }

    public static void checkFillCursor(XTextCursor cursor) {
        String left = "\u200b";
        XTextCursor alpha = cursor.getText().createTextCursorByRange((XTextRange)cursor);
        alpha.collapseToStart();
        XTextCursor omega = cursor.getText().createTextCursorByRange((XTextRange)cursor);
        omega.collapseToEnd();
        short leftLength = (short)"\u200b".length();
        if (leftLength > 0) {
            alpha.goLeft(leftLength, true);
            if (!"\u200b".equals(alpha.getString())) {
                String msg = "checkFillCursor: ('%s') is not prefixed with REFERENCE_MARK_LEFT_BRACKET, has '%s'".formatted(cursor.getString(), alpha.getString());
                throw new IllegalStateException(msg);
            }
        }
        String right = "\u200b";
        short rightLength = (short)"\u200b".length();
        if (rightLength > 0) {
            omega.goRight(rightLength, true);
            if (!"\u200b".equals(omega.getString())) {
                String msg = "checkFillCursor: ('%s') is not followed by REFERENCE_MARK_RIGHT_BRACKET, has '%s'".formatted(cursor.getString(), omega.getString());
                throw new IllegalStateException(msg);
            }
        }
    }

    @Override
    public void cleanFillCursor(XTextDocument doc) throws NoDocumentException, WrappedTargetException {
        boolean removeLeft;
        boolean removeRight;
        short rightLength;
        short leftLength;
        boolean alwaysRemoveBrackets = false;
        boolean removeBracketsFromEmpty = false;
        String name = this.getRangeName();
        XTextCursor full = this.getRawCursor(doc).orElseThrow(IllegalStateException::new);
        String fullText = full.getString();
        String left = "\u200b";
        if (!fullText.startsWith("\u200b")) {
            String msg = "cleanFillCursor: (%s) does not start with REFERENCE_MARK_LEFT_BRACKET".formatted(name);
            throw new IllegalStateException(msg);
        }
        String right = "\u200b";
        if (!fullText.endsWith("\u200b")) {
            String msg = "cleanFillCursor: (%s) does not end with REFERENCE_MARK_RIGHT_BRACKET".formatted(name);
            throw new IllegalStateException(msg);
        }
        int fullTextLength = fullText.length();
        int contentLength = fullTextLength - ((leftLength = (short)"\u200b".length()) + (rightLength = (short)"\u200b".length()));
        if (contentLength < 0) {
            String msg = "cleanFillCursor: length(%s) < 0".formatted(name);
            throw new IllegalStateException(msg);
        }
        if (contentLength >= 1) {
            v0 = true;
        } else {
            if (contentLength == 0) {
                // empty if block
            }
            v0 = removeRight = false;
        }
        if (contentLength >= 2) {
            v1 = true;
        } else {
            if (contentLength == 0) {
                // empty if block
            }
            v1 = removeLeft = false;
        }
        if (removeRight) {
            XTextCursor omega = full.getText().createTextCursorByRange((XTextRange)full);
            omega.collapseToEnd();
            omega.goLeft(rightLength, true);
            omega.setString("");
        }
        if (removeLeft) {
            XTextCursor alpha = full.getText().createTextCursorByRange((XTextRange)full);
            alpha.collapseToStart();
            alpha.goRight(leftLength, true);
            alpha.setString("");
        }
    }
}

