/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.frontend;

import com.sun.star.beans.IllegalTypeException;
import com.sun.star.beans.NotRemoveableException;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jabref.logic.JabRefException;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.openoffice.backend.Backend52;
import org.jabref.logic.openoffice.frontend.RangeForOverlapCheck;
import org.jabref.logic.openoffice.frontend.UpdateBibliography;
import org.jabref.model.openoffice.CitationEntry;
import org.jabref.model.openoffice.ootext.OOText;
import org.jabref.model.openoffice.rangesort.FunctionalTextViewCursor;
import org.jabref.model.openoffice.rangesort.RangeOverlap;
import org.jabref.model.openoffice.rangesort.RangeOverlapBetween;
import org.jabref.model.openoffice.rangesort.RangeOverlapKind;
import org.jabref.model.openoffice.rangesort.RangeOverlapWithin;
import org.jabref.model.openoffice.rangesort.RangeSort;
import org.jabref.model.openoffice.rangesort.RangeSortEntry;
import org.jabref.model.openoffice.rangesort.RangeSortVisual;
import org.jabref.model.openoffice.rangesort.RangeSortable;
import org.jabref.model.openoffice.style.CitationGroup;
import org.jabref.model.openoffice.style.CitationGroupId;
import org.jabref.model.openoffice.style.CitationGroups;
import org.jabref.model.openoffice.style.CitationType;
import org.jabref.model.openoffice.style.OODataModel;
import org.jabref.model.openoffice.uno.CreationException;
import org.jabref.model.openoffice.uno.NoDocumentException;
import org.jabref.model.openoffice.uno.UnoCursor;
import org.jabref.model.openoffice.uno.UnoTextRange;
import org.jabref.model.openoffice.util.OOListUtil;
import org.jabref.model.openoffice.util.OOVoidResult;

public class OOFrontend {
    public final Backend52 backend = new Backend52();
    public final CitationGroups citationGroups;

    public OOFrontend(XTextDocument doc) throws NoDocumentException, WrappedTargetException {
        List<String> citationGroupNames = this.backend.getJabRefReferenceMarkNames(doc);
        Map<CitationGroupId, CitationGroup> citationGroups = OOFrontend.readCitationGroupsFromDocument(this.backend, doc, citationGroupNames);
        this.citationGroups = new CitationGroups(citationGroups);
    }

    public OODataModel getDataModel() {
        return this.backend.dataModel;
    }

    public Optional<String> healthReport(XTextDocument doc) throws NoDocumentException {
        return this.backend.healthReport(doc);
    }

    private static Map<CitationGroupId, CitationGroup> readCitationGroupsFromDocument(Backend52 backend, XTextDocument doc, List<String> citationGroupNames) throws WrappedTargetException, NoDocumentException {
        HashMap<CitationGroupId, CitationGroup> citationGroups = new HashMap<CitationGroupId, CitationGroup>();
        for (String name : citationGroupNames) {
            CitationGroup group = backend.readCitationGroupFromDocumentOrThrow(doc, name);
            citationGroups.put(group.groupId, group);
        }
        return citationGroups;
    }

    private List<RangeSortable<CitationGroup>> createVisualSortInput(XTextDocument doc, boolean mapFootnotesToFootnoteMarks) throws NoDocumentException, WrappedTargetException {
        ArrayList<RangeSortEntry<CitationGroup>> sortables = new ArrayList<RangeSortEntry<CitationGroup>>();
        for (CitationGroup group : this.citationGroups.getCitationGroupsUnordered()) {
            XTextRange range = this.getMarkRange(doc, group).orElseThrow(IllegalStateException::new);
            sortables.add(new RangeSortEntry<CitationGroup>(range, 0, group));
        }
        RangeSort.RangePartitions partitions = RangeSort.partitionAndSortRanges(sortables);
        ArrayList<RangeSortEntry> result = new ArrayList<RangeSortEntry>();
        for (List partition : partitions.getPartitions()) {
            int indexInPartition = 0;
            for (RangeSortEntry sortable : partition) {
                sortable.setIndexInPosition(indexInPartition++);
                if (mapFootnotesToFootnoteMarks) {
                    Optional<XTextRange> footnoteMarkRange = UnoTextRange.getFootnoteMarkRange(sortable.getRange());
                    footnoteMarkRange.ifPresent(sortable::setRange);
                }
                result.add(sortable);
            }
        }
        return new ArrayList<RangeSortable<CitationGroup>>(result);
    }

    private List<CitationGroup> getVisuallySortedCitationGroups(XTextDocument doc, boolean mapFootnotesToFootnoteMarks, FunctionalTextViewCursor fcursor) throws WrappedTargetException, NoDocumentException {
        List sortables = this.createVisualSortInput(doc, mapFootnotesToFootnoteMarks);
        List sorted = RangeSortVisual.visualSort(sortables, doc, fcursor);
        return sorted.stream().map(RangeSortable::getContent).collect(Collectors.toList());
    }

    public List<CitationGroup> getCitationGroupsSortedWithinPartitions(XTextDocument doc, boolean mapFootnotesToFootnoteMarks) throws NoDocumentException, WrappedTargetException {
        List<RangeSortable<CitationGroup>> sortables = this.createVisualSortInput(doc, mapFootnotesToFootnoteMarks);
        return sortables.stream().map(RangeSortable::getContent).collect(Collectors.toList());
    }

    public CitationGroup createCitationGroup(XTextDocument doc, List<String> citationKeys, List<Optional<OOText>> pageInfos, CitationType citationType, XTextCursor position, boolean insertSpaceAfter) throws CreationException, NoDocumentException, WrappedTargetException, NotRemoveableException, PropertyVetoException, IllegalTypeException {
        Objects.requireNonNull(pageInfos);
        if (pageInfos.size() != citationKeys.size()) {
            throw new IllegalArgumentException("pageInfos.size != citationKeys.size");
        }
        CitationGroup group = this.backend.createCitationGroup(doc, citationKeys, pageInfos, citationType, position, insertSpaceAfter);
        this.citationGroups.afterCreateCitationGroup(group);
        return group;
    }

    public void removeCitationGroup(CitationGroup group, XTextDocument doc) throws WrappedTargetException, NoDocumentException, NotRemoveableException {
        this.backend.removeCitationGroup(group, doc);
        this.citationGroups.afterRemoveCitationGroup(group);
    }

    public void removeCitationGroups(List<CitationGroup> citationGroups, XTextDocument doc) throws WrappedTargetException, NoDocumentException, NotRemoveableException {
        for (CitationGroup group : citationGroups) {
            this.removeCitationGroup(group, doc);
        }
    }

    public Optional<XTextRange> getMarkRange(XTextDocument doc, CitationGroup group) throws NoDocumentException, WrappedTargetException {
        return this.backend.getMarkRange(group, doc);
    }

    public XTextCursor getFillCursorForCitationGroup(XTextDocument doc, CitationGroup group) throws NoDocumentException, WrappedTargetException, CreationException {
        return this.backend.getFillCursorForCitationGroup(group, doc);
    }

    public void cleanFillCursorForCitationGroup(XTextDocument doc, CitationGroup group) throws NoDocumentException, WrappedTargetException {
        this.backend.cleanFillCursorForCitationGroup(group, doc);
    }

    public List<RangeForOverlapCheck<CitationGroupId>> citationRanges(XTextDocument doc) throws NoDocumentException, WrappedTargetException {
        ArrayList<RangeForOverlapCheck<CitationGroupId>> result = new ArrayList<RangeForOverlapCheck<CitationGroupId>>(this.citationGroups.numberOfCitationGroups());
        for (CitationGroup group : this.citationGroups.getCitationGroupsUnordered()) {
            XTextRange range = this.getMarkRange(doc, group).orElseThrow(IllegalStateException::new);
            String description = group.groupId.citationGroupIdAsString();
            result.add(new RangeForOverlapCheck<CitationGroupId>(range, group.groupId, 0, description));
        }
        return result;
    }

    public List<RangeForOverlapCheck<CitationGroupId>> bibliographyRanges(XTextDocument doc) throws NoDocumentException, WrappedTargetException {
        ArrayList<RangeForOverlapCheck<CitationGroupId>> result = new ArrayList<RangeForOverlapCheck<CitationGroupId>>();
        Optional<XTextRange> range = UpdateBibliography.getBibliographyRange(doc);
        if (range.isPresent()) {
            String description = "bibliography";
            result.add(new RangeForOverlapCheck<CitationGroupId>(range.get(), new CitationGroupId("bibliography"), 3, description));
        }
        return result;
    }

    public List<RangeForOverlapCheck<CitationGroupId>> viewCursorRanges(XTextDocument doc) {
        ArrayList<RangeForOverlapCheck<CitationGroupId>> result = new ArrayList<RangeForOverlapCheck<CitationGroupId>>();
        Optional<XTextRange> range = UnoCursor.getViewCursor(doc).map(e -> e);
        if (range.isPresent()) {
            String description = "cursor";
            result.add(new RangeForOverlapCheck<CitationGroupId>(range.get(), new CitationGroupId("cursor"), 2, description));
        }
        return result;
    }

    public List<RangeForOverlapCheck<CitationGroupId>> footnoteMarkRanges(XTextDocument doc, List<RangeForOverlapCheck<CitationGroupId>> citationRanges) {
        ArrayList<RangeForOverlapCheck<CitationGroupId>> result = new ArrayList<RangeForOverlapCheck<CitationGroupId>>();
        RangeSort.RangePartitions<RangeForOverlapCheck<CitationGroupId>> partitions = RangeSort.partitionRanges(citationRanges);
        for (List<RangeForOverlapCheck<CitationGroupId>> partition : partitions.getPartitions()) {
            if (partition.isEmpty()) continue;
            RangeForOverlapCheck<CitationGroupId> citationRange = partition.getFirst();
            Optional<XTextRange> footnoteMarkRange = UnoTextRange.getFootnoteMarkRange(citationRange.range);
            if (footnoteMarkRange.isEmpty()) continue;
            result.add(new RangeForOverlapCheck<CitationGroupId>(footnoteMarkRange.get(), (CitationGroupId)citationRange.idWithinKind, 1, "FootnoteMark for " + citationRange.format()));
        }
        return result;
    }

    static String rangeOverlapsToMessage(List<RangeOverlap<RangeForOverlapCheck<CitationGroupId>>> overlaps) {
        if (overlaps.isEmpty()) {
            return "(*no overlaps*)";
        }
        StringBuilder msg = new StringBuilder();
        for (RangeOverlap<RangeForOverlapCheck<CitationGroupId>> overlap : overlaps) {
            String listOfRanges = overlap.valuesForOverlappingRanges.stream().map(v -> "'%s'".formatted(v.format())).collect(Collectors.joining(", "));
            msg.append(switch (overlap.kind) {
                default -> throw new MatchException(null, null);
                case RangeOverlapKind.EQUAL_RANGE -> Localization.lang("Found identical ranges", new Object[0]);
                case RangeOverlapKind.OVERLAP -> Localization.lang("Found overlapping ranges", new Object[0]);
                case RangeOverlapKind.TOUCH -> Localization.lang("Found touching ranges", new Object[0]);
            });
            msg.append(": ");
            msg.append(listOfRanges);
            msg.append("\n");
        }
        return msg.toString();
    }

    public OOVoidResult<JabRefException> checkRangeOverlapsWithCursor(XTextDocument doc, List<RangeForOverlapCheck<CitationGroupId>> userRanges, boolean requireSeparation) throws NoDocumentException, WrappedTargetException {
        List<RangeForOverlapCheck<CitationGroupId>> citationRanges = this.citationRanges(doc);
        ArrayList<RangeForOverlapCheck<CitationGroupId>> ranges = new ArrayList<RangeForOverlapCheck<CitationGroupId>>();
        ranges.addAll(this.bibliographyRanges(doc));
        ranges.addAll(citationRanges);
        ranges.addAll(this.footnoteMarkRanges(doc, citationRanges));
        List<RangeOverlap<RangeForOverlapCheck<CitationGroupId>>> overlaps = RangeOverlapBetween.findFirst(doc, userRanges, ranges, requireSeparation);
        if (overlaps.isEmpty()) {
            return OOVoidResult.ok();
        }
        return OOVoidResult.error(new JabRefException("Found overlapping or touching ranges", OOFrontend.rangeOverlapsToMessage(overlaps)));
    }

    public OOVoidResult<JabRefException> checkRangeOverlaps(XTextDocument doc, List<RangeForOverlapCheck<CitationGroupId>> userRanges, boolean requireSeparation, int reportAtMost) throws NoDocumentException, WrappedTargetException {
        List<RangeForOverlapCheck<CitationGroupId>> citationRanges = this.citationRanges(doc);
        ArrayList<RangeForOverlapCheck<CitationGroupId>> ranges = new ArrayList<RangeForOverlapCheck<CitationGroupId>>();
        ranges.addAll(userRanges);
        ranges.addAll(this.bibliographyRanges(doc));
        ranges.addAll(citationRanges);
        ranges.addAll(this.footnoteMarkRanges(doc, citationRanges));
        List<RangeOverlap<RangeForOverlapCheck<CitationGroupId>>> overlaps = RangeOverlapWithin.findOverlappingRanges(doc, ranges, requireSeparation, reportAtMost);
        if (overlaps.isEmpty()) {
            return OOVoidResult.ok();
        }
        return OOVoidResult.error(new JabRefException("Found overlapping or touching ranges", OOFrontend.rangeOverlapsToMessage(overlaps)));
    }

    public List<CitationEntry> getCitationEntries(XTextDocument doc) throws WrappedTargetException, NoDocumentException {
        return this.backend.getCitationEntries(doc, this.citationGroups);
    }

    public void applyCitationEntries(XTextDocument doc, List<CitationEntry> citationEntries) throws PropertyVetoException, IllegalTypeException, IllegalArgumentException, WrappedTargetException {
        this.backend.applyCitationEntries(doc, citationEntries);
    }

    public void imposeGlobalOrder(XTextDocument doc, FunctionalTextViewCursor fcursor) throws WrappedTargetException, NoDocumentException {
        boolean mapFootnotesToFootnoteMarks = true;
        List<CitationGroup> sortedCitationGroups = this.getVisuallySortedCitationGroups(doc, mapFootnotesToFootnoteMarks, fcursor);
        List<CitationGroupId> sortedCitationGroupIds = OOListUtil.map(sortedCitationGroups, group -> group.groupId);
        this.citationGroups.setGlobalOrder(sortedCitationGroupIds);
    }
}

