/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.style;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.layout.Layout;
import org.jabref.logic.layout.LayoutFormatter;
import org.jabref.logic.layout.LayoutFormatterPreferences;
import org.jabref.logic.layout.LayoutHelper;
import org.jabref.logic.openoffice.style.OOBibStyleGetCitationMarker;
import org.jabref.logic.openoffice.style.OOBibStyleGetNumCitationMarker;
import org.jabref.logic.openoffice.style.OOPreFormatter;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.OrFields;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.EntryTypeFactory;
import org.jabref.model.openoffice.ootext.OOFormat;
import org.jabref.model.openoffice.ootext.OOText;
import org.jabref.model.openoffice.style.CitationMarkerEntry;
import org.jabref.model.openoffice.style.CitationMarkerNormEntry;
import org.jabref.model.openoffice.style.CitationMarkerNumericBibEntry;
import org.jabref.model.openoffice.style.CitationMarkerNumericEntry;
import org.jabref.model.openoffice.style.NonUniqueCitationMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OOBibStyle
implements Comparable<OOBibStyle> {
    public static final String ITALIC_ET_AL = "ItalicEtAl";
    public static final String MULTI_CITE_CHRONOLOGICAL = "MultiCiteChronological";
    public static final String MINIMUM_GROUPING_COUNT = "MinimumGroupingCount";
    public static final String ET_AL_STRING = "EtAlString";
    public static final String MAX_AUTHORS_FIRST = "MaxAuthorsFirst";
    public static final String REFERENCE_HEADER_PARAGRAPH_FORMAT = "ReferenceHeaderParagraphFormat";
    public static final String REFERENCE_PARAGRAPH_FORMAT = "ReferenceParagraphFormat";
    public static final String TITLE = "Title";
    public static final String UNDEFINED_CITATION_MARKER = "??";
    private static final Pattern NUM_PATTERN = Pattern.compile("-?\\d+");
    private static final String LAYOUT_MRK = "LAYOUT";
    private static final String PROPERTIES_MARK = "PROPERTIES";
    private static final String CITATION_MARK = "CITATION";
    private static final String NAME_MARK = "NAME";
    private static final String JOURNALS_MARK = "JOURNALS";
    private static final String DEFAULT_MARK = "default";
    private static final String BRACKET_AFTER_IN_LIST = "BracketAfterInList";
    private static final String BRACKET_BEFORE_IN_LIST = "BracketBeforeInList";
    private static final String UNIQUEFIER_SEPARATOR = "UniquefierSeparator";
    private static final String CITATION_KEY_CITATIONS = "BibTeXKeyCitations";
    private static final String SUBSCRIPT_CITATIONS = "SubscriptCitations";
    private static final String SUPERSCRIPT_CITATIONS = "SuperscriptCitations";
    private static final String BOLD_CITATIONS = "BoldCitations";
    private static final String ITALIC_CITATIONS = "ItalicCitations";
    private static final String CITATION_CHARACTER_FORMAT = "CitationCharacterFormat";
    private static final String FORMAT_CITATIONS = "FormatCitations";
    private static final String GROUPED_NUMBERS_SEPARATOR = "GroupedNumbersSeparator";
    private static final String CITATION_GROUP_MARKUP_BEFORE = "CitationGroupMarkupBefore";
    private static final String CITATION_GROUP_MARKUP_AFTER = "CitationGroupMarkupAfter";
    private static final String AUTHORS_PART_MARKUP_BEFORE = "AuthorsPartMarkupBefore";
    private static final String AUTHORS_PART_MARKUP_AFTER = "AuthorsPartMarkupAfter";
    private static final String AUTHOR_NAMES_LIST_MARKUP_BEFORE = "AuthorNamesListMarkupBefore";
    private static final String AUTHOR_NAMES_LIST_MARKUP_AFTER = "AuthorNamesListMarkupAfter";
    private static final String AUTHOR_NAME_MARKUP_BEFORE = "AuthorNameMarkupBefore";
    private static final String AUTHOR_NAME_MARKUP_AFTER = "AuthorNameMarkupAfter";
    private static final String PAGE_INFO_SEPARATOR = "PageInfoSeparator";
    private static final String CITATION_SEPARATOR = "CitationSeparator";
    private static final String IN_TEXT_YEAR_SEPARATOR = "InTextYearSeparator";
    private static final String MAX_AUTHORS = "MaxAuthors";
    private static final String YEAR_FIELD = "YearField";
    private static final String AUTHOR_FIELD = "AuthorField";
    private static final String BRACKET_AFTER = "BracketAfter";
    private static final String BRACKET_BEFORE = "BracketBefore";
    private static final String SPACE_BEFORE = "SpaceBefore";
    private static final String IS_NUMBER_ENTRIES = "IsNumberEntries";
    private static final String IS_SORT_BY_POSITION = "IsSortByPosition";
    private static final String SORT_ALGORITHM = "SortAlgorithm";
    private static final String OXFORD_COMMA = "OxfordComma";
    private static final String YEAR_SEPARATOR = "YearSeparator";
    private static final String AUTHOR_LAST_SEPARATOR_IN_TEXT = "AuthorLastSeparatorInText";
    private static final String AUTHOR_LAST_SEPARATOR = "AuthorLastSeparator";
    private static final String AUTHOR_SEPARATOR = "AuthorSeparator";
    private static final Pattern QUOTED = Pattern.compile("\".*\"");
    private static final Logger LOGGER = LoggerFactory.getLogger(OOBibStyle.class);
    private final SortedSet<String> journals = new TreeSet<String>();
    private final LayoutFormatter fieldFormatter = new OOPreFormatter();
    private final Map<EntryType, Layout> bibLayout = new HashMap<EntryType, Layout>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<String, Object> citProperties = new HashMap<String, Object>();
    private final boolean fromResource;
    private final String path;
    private final LayoutFormatterPreferences layoutPreferences;
    private final JournalAbbreviationRepository abbreviationRepository;
    private String name = "";
    private Layout defaultBibLayout;
    private boolean valid;
    private Path styleFile;
    private long styleFileModificationTime = Long.MIN_VALUE;
    private String localCopy;
    private boolean isDefaultLayoutPresent;

    public OOBibStyle(Path styleFile, LayoutFormatterPreferences layoutPreferences, JournalAbbreviationRepository abbreviationRepository) throws IOException {
        this.layoutPreferences = Objects.requireNonNull(layoutPreferences);
        this.abbreviationRepository = abbreviationRepository;
        this.styleFile = Objects.requireNonNull(styleFile);
        this.setDefaultProperties();
        this.reload();
        this.fromResource = false;
        this.path = styleFile.toAbsolutePath().toString();
    }

    public OOBibStyle(String resourcePath, LayoutFormatterPreferences layoutPreferences, JournalAbbreviationRepository abbreviationRepository) throws IOException {
        this.layoutPreferences = Objects.requireNonNull(layoutPreferences);
        this.abbreviationRepository = abbreviationRepository;
        Objects.requireNonNull(resourcePath);
        this.setDefaultProperties();
        this.initialize(OOBibStyle.class.getResourceAsStream(resourcePath));
        this.fromResource = true;
        this.path = resourcePath;
    }

    public Layout getDefaultBibLayout() {
        return this.defaultBibLayout;
    }

    private void setDefaultProperties() {
        this.properties.put(TITLE, "Bibliography");
        this.properties.put(SORT_ALGORITHM, "alphanumeric");
        this.properties.put(IS_SORT_BY_POSITION, Boolean.FALSE);
        this.properties.put(IS_NUMBER_ENTRIES, Boolean.FALSE);
        this.properties.put(BRACKET_BEFORE, "[");
        this.properties.put(BRACKET_AFTER, "]");
        this.properties.put(REFERENCE_PARAGRAPH_FORMAT, "Standard");
        this.properties.put(REFERENCE_HEADER_PARAGRAPH_FORMAT, "Heading 1");
        this.citProperties.put(AUTHOR_FIELD, FieldFactory.serializeOrFields(StandardField.AUTHOR, StandardField.EDITOR));
        this.citProperties.put(CITATION_GROUP_MARKUP_BEFORE, "");
        this.citProperties.put(CITATION_GROUP_MARKUP_AFTER, "");
        this.citProperties.put(AUTHORS_PART_MARKUP_BEFORE, "");
        this.citProperties.put(AUTHORS_PART_MARKUP_AFTER, "");
        this.citProperties.put(AUTHOR_NAMES_LIST_MARKUP_BEFORE, "");
        this.citProperties.put(AUTHOR_NAMES_LIST_MARKUP_AFTER, "");
        this.citProperties.put(AUTHOR_NAME_MARKUP_BEFORE, "");
        this.citProperties.put(AUTHOR_NAME_MARKUP_AFTER, "");
        this.citProperties.put(YEAR_FIELD, StandardField.YEAR.getName());
        this.citProperties.put(MAX_AUTHORS, 3);
        this.citProperties.put(MAX_AUTHORS_FIRST, -1);
        this.citProperties.put(AUTHOR_SEPARATOR, ", ");
        this.citProperties.put(AUTHOR_LAST_SEPARATOR, " & ");
        this.citProperties.put(AUTHOR_LAST_SEPARATOR_IN_TEXT, null);
        this.citProperties.put(ET_AL_STRING, " et al.");
        this.citProperties.put(YEAR_SEPARATOR, ", ");
        this.citProperties.put(IN_TEXT_YEAR_SEPARATOR, " ");
        this.citProperties.put(BRACKET_BEFORE, "(");
        this.citProperties.put(BRACKET_AFTER, ")");
        this.citProperties.put(SPACE_BEFORE, Boolean.TRUE);
        this.citProperties.put(CITATION_SEPARATOR, "; ");
        this.citProperties.put(PAGE_INFO_SEPARATOR, "; ");
        this.citProperties.put(GROUPED_NUMBERS_SEPARATOR, "-");
        this.citProperties.put(MINIMUM_GROUPING_COUNT, 3);
        this.citProperties.put(FORMAT_CITATIONS, Boolean.FALSE);
        this.citProperties.put(CITATION_CHARACTER_FORMAT, "Standard");
        this.citProperties.put(ITALIC_CITATIONS, Boolean.FALSE);
        this.citProperties.put(BOLD_CITATIONS, Boolean.FALSE);
        this.citProperties.put(SUPERSCRIPT_CITATIONS, Boolean.FALSE);
        this.citProperties.put(SUBSCRIPT_CITATIONS, Boolean.FALSE);
        this.citProperties.put(MULTI_CITE_CHRONOLOGICAL, Boolean.TRUE);
        this.citProperties.put(CITATION_KEY_CITATIONS, Boolean.FALSE);
        this.citProperties.put(ITALIC_ET_AL, Boolean.FALSE);
        this.citProperties.put(OXFORD_COMMA, "");
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public Path getFile() {
        return this.styleFile;
    }

    public Set<String> getJournals() {
        return Collections.unmodifiableSet(this.journals);
    }

    private void initialize(InputStream stream) throws IOException {
        Objects.requireNonNull(stream);
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            this.readFormatFile(reader);
        }
    }

    public void ensureUpToDate() throws IOException {
        if (!this.isUpToDate()) {
            this.reload();
        }
    }

    private void reload() throws IOException {
        if (this.styleFile != null) {
            this.styleFileModificationTime = Files.getLastModifiedTime(this.styleFile, new LinkOption[0]).toMillis();
            try (InputStream stream = Files.newInputStream(this.styleFile, new OpenOption[0]);){
                this.initialize(stream);
            }
        }
    }

    private boolean isUpToDate() {
        if (this.styleFile == null) {
            return true;
        }
        try {
            return Files.getLastModifiedTime(this.styleFile, new LinkOption[0]).toMillis() == this.styleFileModificationTime;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void readFormatFile(Reader input) throws IOException {
        int chr;
        StringBuilder stringBuilder = new StringBuilder();
        while ((chr = input.read()) != -1) {
            stringBuilder.append((char)chr);
        }
        this.localCopy = stringBuilder.toString();
        String[] lines = stringBuilder.toString().split("\n");
        BibStyleMode mode = BibStyleMode.NONE;
        block22: for (String line1 : lines) {
            String line = line1;
            if (!line.isEmpty() && line.charAt(line.length() - 1) == '\r') {
                line = line.substring(0, line.length() - 1);
            }
            if (line.trim().isEmpty() || line.charAt(0) == '#') continue;
            switch (line) {
                case "NAME": {
                    mode = BibStyleMode.NAME;
                    continue block22;
                }
                case "LAYOUT": {
                    mode = BibStyleMode.LAYOUT;
                    continue block22;
                }
                case "PROPERTIES": {
                    mode = BibStyleMode.PROPERTIES;
                    continue block22;
                }
                case "CITATION": {
                    mode = BibStyleMode.CITATION;
                    continue block22;
                }
                case "JOURNALS": {
                    mode = BibStyleMode.JOURNALS;
                    continue block22;
                }
                default: {
                    switch (mode.ordinal()) {
                        case 4: {
                            if (line.trim().isEmpty()) continue block22;
                            this.name = line.trim();
                            continue block22;
                        }
                        case 1: {
                            this.handleStructureLine(line);
                            continue block22;
                        }
                        case 2: {
                            this.handlePropertiesLine(line, this.properties);
                            continue block22;
                        }
                        case 3: {
                            this.handlePropertiesLine(line, this.citProperties);
                            continue block22;
                        }
                        case 5: {
                            this.handleJournalsLine(line);
                            continue block22;
                        }
                    }
                }
            }
        }
        if (mode != BibStyleMode.NONE && this.isDefaultLayoutPresent) {
            this.valid = true;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    private void handleStructureLine(String line) {
        int index = line.indexOf(61);
        if (index > 0 && index < line.length() - 1) {
            try {
                String typeName = line.substring(0, index);
                String formatString = line.substring(index + 1);
                Layout layout = new LayoutHelper(new StringReader(formatString), this.layoutPreferences, this.abbreviationRepository).getLayoutFromText();
                EntryType type = EntryTypeFactory.parse(typeName);
                if (!this.isDefaultLayoutPresent && DEFAULT_MARK.equals(typeName)) {
                    this.isDefaultLayoutPresent = true;
                    this.defaultBibLayout = layout;
                } else {
                    this.bibLayout.put(type, layout);
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Cannot parse bibliography structure", (Throwable)ex);
            }
        }
    }

    private void handlePropertiesLine(String line, Map<String, Object> map) {
        int index = line.indexOf(61);
        if (index > 0 && index <= line.length() - 1) {
            String propertyName = line.substring(0, index).trim();
            String value = line.substring(index + 1);
            if (value.trim().length() > 1 && QUOTED.matcher(value.trim()).matches()) {
                value = value.trim().substring(1, value.trim().length() - 1);
            }
            Object toSet = value;
            if (NUM_PATTERN.matcher(value.trim()).matches()) {
                toSet = Integer.parseInt(value.trim());
            } else if ("true".equalsIgnoreCase(value.trim())) {
                toSet = Boolean.TRUE;
            } else if ("false".equalsIgnoreCase(value.trim())) {
                toSet = Boolean.FALSE;
            }
            map.put(propertyName, toSet);
        }
    }

    private void handleJournalsLine(String line) {
        if (!line.trim().isEmpty()) {
            this.journals.add(line.trim());
        }
    }

    public Layout getReferenceFormat(EntryType type) {
        Layout layout = this.bibLayout.get(type);
        if (layout == null) {
            return this.defaultBibLayout;
        }
        return layout;
    }

    public boolean isNumberEntries() {
        return (Boolean)this.getProperty(IS_NUMBER_ENTRIES);
    }

    public boolean isSortByPosition() {
        return (Boolean)this.getProperty(IS_SORT_BY_POSITION);
    }

    public boolean isItalicCitations() {
        return (Boolean)this.citProperties.get(ITALIC_CITATIONS);
    }

    public boolean isBoldCitations() {
        return (Boolean)this.citProperties.get(BOLD_CITATIONS);
    }

    public boolean isFormatCitations() {
        return (Boolean)this.citProperties.get(FORMAT_CITATIONS);
    }

    public boolean spaceBeforeCitation() {
        return (Boolean)this.citProperties.get(SPACE_BEFORE);
    }

    public boolean isCitationKeyCiteMarkers() {
        return (Boolean)this.citProperties.get(CITATION_KEY_CITATIONS);
    }

    public boolean getBooleanCitProperty(String key) {
        return (Boolean)this.citProperties.get(key);
    }

    public int getIntCitProperty(String key) {
        return (Integer)this.citProperties.get(key);
    }

    public String getStringCitProperty(String key) {
        return (String)this.citProperties.get(key);
    }

    public String getCitationCharacterFormat() {
        return this.getStringCitProperty(CITATION_CHARACTER_FORMAT);
    }

    public Object getProperty(String propName) {
        return this.properties.get(propName);
    }

    public boolean isInternalStyle() {
        return this.fromResource;
    }

    public String getLocalCopy() {
        return this.localCopy;
    }

    @Override
    public int compareTo(OOBibStyle other) {
        return this.getName().compareTo(other.getName());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof OOBibStyle) {
            OOBibStyle otherStyle = (OOBibStyle)object;
            return Objects.equals(this.path, otherStyle.path) && Objects.equals(this.name, otherStyle.name) && Objects.equals(this.citProperties, otherStyle.citProperties) && Objects.equals(this.properties, otherStyle.properties);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.name, this.citProperties, this.properties);
    }

    public String getEtAlString() {
        return this.getStringCitProperty(ET_AL_STRING);
    }

    protected String getAuthorSeparator() {
        return this.getStringCitProperty(AUTHOR_SEPARATOR);
    }

    protected String getOxfordComma() {
        return this.getStringCitProperty(OXFORD_COMMA);
    }

    public OOText getReferenceHeaderText() {
        return OOText.fromString(this.getStringProperty(TITLE));
    }

    public String getReferenceHeaderParagraphFormat() {
        return this.getStringProperty(REFERENCE_HEADER_PARAGRAPH_FORMAT);
    }

    public String getReferenceParagraphFormat() {
        return this.getStringProperty(REFERENCE_PARAGRAPH_FORMAT);
    }

    protected LayoutFormatter getFieldFormatter() {
        return this.fieldFormatter;
    }

    protected Map<EntryType, Layout> getBibLayout() {
        return this.bibLayout;
    }

    protected Map<String, Object> getProperties() {
        return this.properties;
    }

    protected Map<String, Object> getCitProperties() {
        return this.citProperties;
    }

    protected void addJournal(String journalName) {
        this.journals.add(journalName);
    }

    protected void setLocalCopy(String contentsOfJstyleFile) {
        this.localCopy = contentsOfJstyleFile;
    }

    protected void setName(String nameOfTheStyle) {
        this.name = nameOfTheStyle;
    }

    protected boolean getIsDefaultLayoutPresent() {
        return this.isDefaultLayoutPresent;
    }

    protected void setIsDefaultLayoutPresent(boolean isPresent) {
        this.isDefaultLayoutPresent = isPresent;
    }

    protected void setValid(boolean isValid) {
        this.valid = isValid;
    }

    protected LayoutFormatterPreferences getLayoutPreferences() {
        return this.layoutPreferences;
    }

    protected void setDefaultBibLayout(Layout layout) {
        this.defaultBibLayout = layout;
    }

    public OOText getNumCitationMarker2(List<CitationMarkerNumericEntry> entries) {
        int minGroupingCount = this.getMinimumGroupingCount();
        return OOBibStyleGetNumCitationMarker.getNumCitationMarker2(this, entries, minGroupingCount);
    }

    public OOText getNumCitationMarker2(List<CitationMarkerNumericEntry> entries, int minGroupingCount) {
        return OOBibStyleGetNumCitationMarker.getNumCitationMarker2(this, entries, minGroupingCount);
    }

    public OOText getNumCitationMarkerForBibliography(CitationMarkerNumericBibEntry entry) {
        return OOBibStyleGetNumCitationMarker.getNumCitationMarkerForBibliography(this, entry);
    }

    public OOText getNormalizedCitationMarker(CitationMarkerNormEntry entry) {
        return OOBibStyleGetCitationMarker.getNormalizedCitationMarker(this, entry, Optional.empty());
    }

    public OOText createCitationMarker(List<CitationMarkerEntry> citationMarkerEntries, boolean inParenthesis, NonUniqueCitationMarker nonUniqueCitationMarkerHandling) {
        return OOBibStyleGetCitationMarker.createCitationMarker(this, citationMarkerEntries, inParenthesis, nonUniqueCitationMarkerHandling);
    }

    public OOText decorateCitationMarker(OOText citationText) {
        OOBibStyle style = this;
        OOText citationText2 = OOFormat.setLocaleNone(citationText);
        if (style.isFormatCitations()) {
            String charStyle = style.getCitationCharacterFormat();
            citationText2 = OOFormat.setCharStyle(citationText2, charStyle);
        }
        return citationText2;
    }

    public int getMinimumGroupingCount() {
        return this.getIntCitProperty(MINIMUM_GROUPING_COUNT);
    }

    public String getGroupedNumbersSeparator() {
        return this.getStringCitProperty(GROUPED_NUMBERS_SEPARATOR);
    }

    private String getStringProperty(String propName) {
        return (String)this.properties.get(propName);
    }

    public String getCitationGroupMarkupBefore() {
        return this.getStringCitProperty(CITATION_GROUP_MARKUP_BEFORE);
    }

    public String getCitationGroupMarkupAfter() {
        return this.getStringCitProperty(CITATION_GROUP_MARKUP_AFTER);
    }

    public String getAuthorsPartMarkupBefore() {
        return this.getStringCitProperty(AUTHORS_PART_MARKUP_BEFORE);
    }

    public String getAuthorsPartMarkupAfter() {
        return this.getStringCitProperty(AUTHORS_PART_MARKUP_AFTER);
    }

    public String getAuthorNamesListMarkupBefore() {
        return this.getStringCitProperty(AUTHOR_NAMES_LIST_MARKUP_BEFORE);
    }

    public String getAuthorNamesListMarkupAfter() {
        return this.getStringCitProperty(AUTHOR_NAMES_LIST_MARKUP_AFTER);
    }

    public String getAuthorNameMarkupBefore() {
        return this.getStringCitProperty(AUTHOR_NAME_MARKUP_BEFORE);
    }

    public String getAuthorNameMarkupAfter() {
        return this.getStringCitProperty(AUTHOR_NAME_MARKUP_AFTER);
    }

    public boolean getMultiCiteChronological() {
        return this.getBooleanCitProperty(MULTI_CITE_CHRONOLOGICAL);
    }

    public boolean getItalicEtAl() {
        return this.getBooleanCitProperty(ITALIC_ET_AL);
    }

    protected OrFields getAuthorFieldNames() {
        String authorFieldNamesString = this.getStringCitProperty(AUTHOR_FIELD);
        return FieldFactory.parseOrFields(authorFieldNamesString);
    }

    protected OrFields getYearFieldNames() {
        String yearFieldNamesString = this.getStringCitProperty(YEAR_FIELD);
        return FieldFactory.parseOrFields(yearFieldNamesString);
    }

    protected String getAuthorLastSeparator() {
        return this.getStringCitProperty(AUTHOR_LAST_SEPARATOR);
    }

    protected String getAuthorLastSeparatorInTextWithFallBack() {
        String preferred = this.getStringCitProperty(AUTHOR_LAST_SEPARATOR_IN_TEXT);
        String fallback = this.getStringCitProperty(AUTHOR_LAST_SEPARATOR);
        return Objects.requireNonNullElse(preferred, fallback);
    }

    protected String getPageInfoSeparator() {
        return this.getStringCitProperty(PAGE_INFO_SEPARATOR);
    }

    protected String getUniquefierSeparator() {
        return this.getStringCitProperty(UNIQUEFIER_SEPARATOR);
    }

    protected String getCitationSeparator() {
        return this.getStringCitProperty(CITATION_SEPARATOR);
    }

    protected String getYearSeparator() {
        return this.getStringCitProperty(YEAR_SEPARATOR);
    }

    protected String getYearSeparatorInText() {
        return this.getStringCitProperty(IN_TEXT_YEAR_SEPARATOR);
    }

    protected int getMaxAuthors() {
        return this.getIntCitProperty(MAX_AUTHORS);
    }

    public int getMaxAuthorsFirst() {
        return this.getIntCitProperty(MAX_AUTHORS_FIRST);
    }

    protected String getBracketBefore() {
        return this.getStringCitProperty(BRACKET_BEFORE);
    }

    protected String getBracketAfter() {
        return this.getStringCitProperty(BRACKET_AFTER);
    }

    private String getBracketBeforeInList() {
        return this.getStringCitProperty(BRACKET_BEFORE_IN_LIST);
    }

    public String getBracketBeforeInListWithFallBack() {
        return Objects.requireNonNullElse(this.getBracketBeforeInList(), this.getBracketBefore());
    }

    private String getBracketAfterInList() {
        return this.getStringCitProperty(BRACKET_AFTER_IN_LIST);
    }

    String getBracketAfterInListWithFallBack() {
        return Objects.requireNonNullElse(this.getBracketAfterInList(), this.getBracketAfter());
    }

    public OOText getFormattedBibliographyTitle() {
        OOBibStyle style = this;
        OOText title = style.getReferenceHeaderText();
        String parStyle = style.getReferenceHeaderParagraphFormat();
        return parStyle == null ? OOFormat.paragraph(title) : OOFormat.paragraph(title, parStyle);
    }

    static enum BibStyleMode {
        NONE,
        LAYOUT,
        PROPERTIES,
        CITATION,
        NAME,
        JOURNALS;

    }
}

