/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.pdf;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.jabref.logic.pdf.EntryAnnotationImporter;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.pdf.FileAnnotation;
import org.jabref.preferences.FilePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAnnotationCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAnnotation.class);
    private static final int CACHE_SIZE = 10;
    private LoadingCache<BibEntry, Map<Path, List<FileAnnotation>>> annotationCache;

    public FileAnnotationCache() {
    }

    public FileAnnotationCache(final BibDatabaseContext context, final FilePreferences filePreferences) {
        this.annotationCache = CacheBuilder.newBuilder().maximumSize(10L).build((CacheLoader)new CacheLoader<BibEntry, Map<Path, List<FileAnnotation>>>(this){

            public Map<Path, List<FileAnnotation>> load(BibEntry entry) throws Exception {
                return new EntryAnnotationImporter(entry).importAnnotationsFromFiles(context, filePreferences);
            }
        });
    }

    public Map<Path, List<FileAnnotation>> getFromCache(BibEntry entry) {
        LOGGER.debug("Loading Bibentry '%s' from cache.".formatted(entry.getCitationKey().orElse(entry.getId())));
        return (Map)this.annotationCache.getUnchecked((Object)entry);
    }

    public void remove(BibEntry entry) {
        LOGGER.debug("Deleted Bibentry '%s' from cache.".formatted(entry.getCitationKey().orElse(entry.getId())));
        this.annotationCache.invalidate((Object)entry);
    }
}

