/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.pdf.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.jabref.gui.LibraryTab;
import org.jabref.logic.pdf.search.PdfIndexer;
import org.jabref.model.pdf.search.PdfSearchResults;
import org.jabref.model.pdf.search.SearchFieldConstants;
import org.jabref.model.pdf.search.SearchResult;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PdfSearcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(LibraryTab.class);
    private final PdfIndexer indexer;
    private final Analyzer englishAnalyzer = new EnglishAnalyzer();

    private PdfSearcher(PdfIndexer indexer) {
        this.indexer = indexer;
    }

    public static PdfSearcher of(PdfIndexer indexer) throws IOException {
        return new PdfSearcher(indexer);
    }

    public PdfSearchResults search(String searchString, int maxHits) throws IOException {
        PdfSearchResults pdfSearchResults;
        block12: {
            if (StringUtil.isBlank(Objects.requireNonNull(searchString, "The search string was null."))) {
                return new PdfSearchResults();
            }
            if (maxHits <= 0) {
                throw new IllegalArgumentException("Must be called with at least 1 maxHits, was " + maxHits);
            }
            ArrayList<SearchResult> resultDocs = new ArrayList<SearchResult>();
            Optional<IndexWriter> optionalIndexWriter = this.indexer.getIndexWriter();
            if (optionalIndexWriter.isEmpty()) {
                LOGGER.info("No index writer present, returning empty result set.");
                return new PdfSearchResults();
            }
            DirectoryReader reader = DirectoryReader.open((IndexWriter)optionalIndexWriter.get());
            try {
                Query query = new MultiFieldQueryParser(SearchFieldConstants.PDF_FIELDS, this.englishAnalyzer).parse(searchString);
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                TopDocs results = searcher.search(query, maxHits);
                for (ScoreDoc scoreDoc : results.scoreDocs) {
                    resultDocs.add(new SearchResult(searcher, query, scoreDoc));
                }
                pdfSearchResults = new PdfSearchResults(resultDocs);
                if (reader == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException e) {
                    LOGGER.warn("Could not parse query: '{}'", (Object)searchString, (Object)e);
                    return new PdfSearchResults();
                }
            }
            reader.close();
        }
        return pdfSearchResults;
    }
}

