/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.protectedterms;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.protectedterms.ProtectedTermsList;
import org.jabref.logic.protectedterms.ProtectedTermsParser;
import org.jabref.logic.protectedterms.ProtectedTermsPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedTermsLoader {
    private static final Map<String, Supplier<String>> INTERNAL_LISTS = new HashMap<String, Supplier<String>>();
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtectedTermsLoader.class);
    private final List<ProtectedTermsList> mainList = new ArrayList<ProtectedTermsList>();

    public ProtectedTermsLoader(ProtectedTermsPreferences preferences) {
        this.update(preferences);
    }

    public static List<String> getInternalLists() {
        return new ArrayList<String>(INTERNAL_LISTS.keySet());
    }

    public void update(ProtectedTermsPreferences preferences) {
        this.mainList.clear();
        for (String filename : preferences.getEnabledInternalTermLists()) {
            if (INTERNAL_LISTS.containsKey(filename)) {
                this.mainList.add(ProtectedTermsLoader.readProtectedTermsListFromResource(filename, INTERNAL_LISTS.get(filename).get(), true));
                continue;
            }
            LOGGER.warn("Protected terms resource '{}' is no longer available.", (Object)filename);
        }
        for (String filename : preferences.getDisabledInternalTermLists()) {
            if (INTERNAL_LISTS.containsKey(filename)) {
                if (preferences.getEnabledInternalTermLists().contains((Object)filename)) continue;
                this.mainList.add(ProtectedTermsLoader.readProtectedTermsListFromResource(filename, INTERNAL_LISTS.get(filename).get(), false));
                continue;
            }
            LOGGER.warn("Protected terms resource '{}' is no longer available.", (Object)filename);
        }
        for (String filename : INTERNAL_LISTS.keySet()) {
            if (preferences.getEnabledInternalTermLists().contains((Object)filename) || preferences.getDisabledInternalTermLists().contains((Object)filename)) continue;
            this.mainList.add(ProtectedTermsLoader.readProtectedTermsListFromResource(filename, INTERNAL_LISTS.get(filename).get(), true));
            LOGGER.warn("New protected terms resource '{}' is available and enabled by default.", (Object)filename);
        }
        for (String filename : preferences.getEnabledExternalTermLists()) {
            Path filePath = Path.of(filename, new String[0]);
            if (Files.exists(filePath, new LinkOption[0])) {
                this.mainList.add(ProtectedTermsLoader.readProtectedTermsListFromFile(filePath, true));
                continue;
            }
            LOGGER.warn("Cannot find protected terms file {} ", (Object)filename);
        }
        for (String filename : preferences.getDisabledExternalTermLists()) {
            if (preferences.getEnabledExternalTermLists().contains((Object)filename)) continue;
            this.mainList.add(ProtectedTermsLoader.readProtectedTermsListFromFile(Path.of(filename, new String[0]), false));
        }
    }

    public void reloadProtectedTermsList(ProtectedTermsList list) {
        ProtectedTermsList newList = ProtectedTermsLoader.readProtectedTermsListFromFile(Path.of(list.getLocation(), new String[0]), list.isEnabled());
        int index = this.mainList.indexOf(list);
        if (index >= 0) {
            this.mainList.set(index, newList);
        } else {
            LOGGER.warn("Problem reloading protected terms file");
        }
    }

    public List<ProtectedTermsList> getProtectedTermsLists() {
        return this.mainList;
    }

    public List<String> getProtectedTerms() {
        HashSet<String> result = new HashSet<String>();
        for (ProtectedTermsList list : this.mainList) {
            if (!list.isEnabled()) continue;
            result.addAll(list.getTermList());
        }
        return new ArrayList<String>(result);
    }

    public void addProtectedTermsListFromFile(String fileName, boolean enabled) {
        this.mainList.add(ProtectedTermsLoader.readProtectedTermsListFromFile(Path.of(fileName, new String[0]), enabled));
    }

    public static ProtectedTermsList readProtectedTermsListFromResource(String resource, String description, boolean enabled) {
        ProtectedTermsParser parser = new ProtectedTermsParser();
        parser.readTermsFromResource(Objects.requireNonNull(resource), Objects.requireNonNull(description));
        return parser.getProtectTermsList(enabled, true);
    }

    public static ProtectedTermsList readProtectedTermsListFromFile(Path path, boolean enabled) {
        LOGGER.debug("Reading term list from file {}", (Object)path);
        ProtectedTermsParser parser = new ProtectedTermsParser();
        parser.readTermsFromFile(Objects.requireNonNull(path));
        return parser.getProtectTermsList(enabled, false);
    }

    public boolean removeProtectedTermsList(ProtectedTermsList termList) {
        termList.setEnabled(false);
        return this.mainList.remove(termList);
    }

    public ProtectedTermsList addNewProtectedTermsList(String newDescription, String newLocation, boolean enabled) {
        Objects.requireNonNull(newDescription);
        Objects.requireNonNull(newLocation);
        ProtectedTermsList resultingList = new ProtectedTermsList(newDescription, new ArrayList<String>(), newLocation);
        resultingList.setEnabled(enabled);
        resultingList.createAndWriteHeading(newDescription);
        this.mainList.add(resultingList);
        return resultingList;
    }

    public ProtectedTermsList addNewProtectedTermsList(String newDescription, String newLocation) {
        return this.addNewProtectedTermsList(newDescription, newLocation, true);
    }

    static {
        INTERNAL_LISTS.put("/protectedterms/months_weekdays.terms", () -> Localization.lang("Months and weekdays in English", new Object[0]));
        INTERNAL_LISTS.put("/protectedterms/countries_territories.terms", () -> Localization.lang("Countries and territories in English", new Object[0]));
        INTERNAL_LISTS.put("/protectedterms/electrical_engineering.terms", () -> Localization.lang("Electrical engineering terms", new Object[0]));
        INTERNAL_LISTS.put("/protectedterms/computer_science.terms", () -> Localization.lang("Computer science", new Object[0]));
    }
}

