/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.texparser;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.OpenDatabase;
import org.jabref.logic.importer.ParserResult;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.texparser.LatexBibEntriesResolverResult;
import org.jabref.model.texparser.LatexParserResults;
import org.jabref.model.util.FileUpdateMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TexBibEntriesResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TexBibEntriesResolver.class);
    private final BibDatabase masterDatabase;
    private final ImportFormatPreferences importFormatPreferences;
    private final FileUpdateMonitor fileMonitor;

    public TexBibEntriesResolver(BibDatabase masterDatabase, ImportFormatPreferences importFormatPreferences, FileUpdateMonitor fileMonitor) {
        this.masterDatabase = masterDatabase;
        this.importFormatPreferences = importFormatPreferences;
        this.fileMonitor = fileMonitor;
    }

    public LatexBibEntriesResolverResult resolve(LatexParserResults latexParserResults) {
        LatexBibEntriesResolverResult resolverResult = new LatexBibEntriesResolverResult(latexParserResults);
        List<BibDatabase> bibDatabases = latexParserResults.getBibFiles().stream().map(path -> {
            try {
                return OpenDatabase.loadDatabase(path, this.importFormatPreferences, this.fileMonitor).getDatabase();
            }
            catch (IOException e) {
                LOGGER.error("Error opening file '{}'", path, (Object)e);
                return ParserResult.fromError(e).getDatabase();
            }
        }).toList();
        List<BibEntry> newEntries = this.findNewEntries(bibDatabases, latexParserResults.getCitations().keySet());
        resolverResult.getNewEntries().addAll(newEntries);
        return resolverResult;
    }

    private List<BibEntry> findNewEntries(List<BibDatabase> bibDatabases, Set<String> citations) {
        return bibDatabases.stream().flatMap(database -> citations.stream().flatMap(citation -> database.getEntriesByCitationKey((String)citation).stream()).filter(entry -> !entry.equals(this.masterDatabase.getEntryByCitationKey(entry.getCitationKey().orElse("")).orElse(new BibEntry()))).map(entry -> this.addCrossReferencingData((BibEntry)entry, (BibDatabase)database))).toList();
    }

    private BibEntry addCrossReferencingData(BibEntry entry, BibDatabase bibDatabase) {
        bibDatabase.getReferencedEntry(entry).ifPresent(refEntry -> refEntry.getFields().forEach(field -> entry.getFieldMap().putIfAbsent((Field)field, refEntry.getFieldOrAlias((Field)field).orElse(""))));
        return entry;
    }
}

