/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util.io;

import org.jabref.logic.util.io.AutoLinkPreferences;
import org.jabref.logic.util.io.CitationKeyBasedFileFinder;
import org.jabref.logic.util.io.FileFinder;
import org.jabref.logic.util.io.RegExpBasedFileFinder;

public class FileFinders {
    public static FileFinder constructFromConfiguration(AutoLinkPreferences autoLinkPreferences) {
        return switch (autoLinkPreferences.getCitationKeyDependency()) {
            default -> throw new MatchException(null, null);
            case AutoLinkPreferences.CitationKeyDependency.START -> new CitationKeyBasedFileFinder(false);
            case AutoLinkPreferences.CitationKeyDependency.EXACT -> new CitationKeyBasedFileFinder(true);
            case AutoLinkPreferences.CitationKeyDependency.REGEX -> new RegExpBasedFileFinder(autoLinkPreferences.getRegularExpression(), autoLinkPreferences.getKeywordSeparator());
        };
    }
}

